export class Labyrinth {

    constructor(grid) {
        this.grid = grid;
        this.dirs = [[1,0],[0,1],[-1,0],[0,-1]];
        this.init();
    }

    // Start with completely disconnected labyrinth
    init() {
        for (let r=0; r<this.grid.rows; r++) {
            for (let c=0; c<this.grid.cols; c++) {
                if (r%2==1 && c%2==1) {
                    this.grid.set(r,c,1);
                } else {
                    this.grid.set(r,c,0);
                }
            }
        }
        this.todo=[[1,1]];
        this.running = false;
    }

    
    removeMarks(bound=1) {
        for (let r=0; r<this.grid.rows; r++) {
            for (let c=0; c<this.grid.cols; c++) {
                if (this.grid.get(r,c)>bound) {
                    this.grid.set(r,c,1);
                }
            }
        }
    }


    // Shuffles an array in place
    permute(a) {
        for (let i=0; i<a.length-1; i++) {
            let j = Math.floor(Math.random()*(a.length-i))+i;
            let temp = a[i];
            a[i] = a[j];
            a[j] = temp;
        }
    }

    vecadd(a,b, mul=1) {
        return [Number(a[0])+Number(b[0])*mul, Number(a[1])+Number(b[1])*mul];
    }


    // Works on an element of the todo list and updates it accordingly
    step(cutprob=0.05) {
        let change = false;
        if (Math.random()<cutprob) {   // smaller values make larger corridors
            this.permute(this.todo);
        }
        let [r,c] = this.todo.pop();
        this.grid.set(r,c,2);
        this.permute(this.dirs);
        for (let d=0; d<4; d++) {
            let [rr,cc] = this.vecadd([r,c], this.dirs[d],2);
            if (this.grid.on(rr,cc) && this.grid.get(rr,cc)==1) {
                let [rrr,ccc] = this.vecadd([r,c], this.dirs[d]);
                this.grid.set(rrr,ccc,3);
                this.grid.set(rr,cc,2);
                if (d<3) {
                    this.todo.push([r,c]);
                } 
                this.todo.push([rr,cc]);
                change = true;
                break;
            }
        }
        if (!change) this.grid.set(r,c,4);
        return change;
    }

    // Watch it generate the labyrinth
    animate() {
        // while (this.todo.length>0 && !this.step());
        if (!this.running) {
            this.init();
        }
        this.running=true;
        if (this.todo.length>0) {
            this.step();
            // Bei dieser Art von anonymer Funktion bleibt die
            // Referenz auf das aktuelle Instanz (this) erhalten.
            setTimeout(()=>this.animate(),20);

            // Bei einer Defintion mit function müsste wie folgt
            // gearbeitet werden:
            /*
            let that = this;  // Referenz auf aktuelle Instanz speicher
            setTimeout(function() {
                // this referenziert hier window (das globale Objekt)
                that.animate();   // Closure: Verwendung von Variablen der äusseren Funktion
            },100);
            */
        } else {
            this.removeMarks();
            this.running = false;
        }
    }

    generate() {
        this.init();
        while(this.todo.length>0) this.step();
        this.removeMarks();
    }


}