window.addEventListener('load', function() {

    let rows = 0;
    let cols = 0;
    let elements = [];
    let feld = document.getElementById("feld");
    let colors = ["black", "red", "yellow", "green", "cyan", "blue", "magenta", "white"];
    let classes = []
    let dirs = [[1,0], [0,1], [-1,0], [0,-1]]  // Richtungen, trigonometrisch geordnet


    function init_grid(r,c) {
        rows = r;
        cols = c;
        feld.style.gridTemplateColumns = `repeat(${cols}, 1fr)`
        for (r=0; r<rows; r++) {
            elements[r] = [];
            for (c=0; c<cols; c++) {
                let div = document.createElement('div');
                div.setAttribute('spalte', c);
                div.setAttribute('zeile', r);
                div.setAttribute('wert', 0);
                // div.classList.add("basic")
                feld.appendChild(div);
                elements[r][c] = div;
                set(r,c,0)
            }
        }
        document.styleSheets[0].insertRule(`#feld div{width:min(${90/cols}vw, ${90/rows}vh);}`)
        colors.forEach((color,i) => {
            let c = `feld${color}`
            classes.push(c);
            document.styleSheets[0].insertRule(`.${c} { background-color:${color};}`)
        })
    }

    function set(row, col, val) {
        if (!on(row, col)) return; // Ausserhalb vom Feld
        let el = elements[row][col]
        let old = el.wert
        if (old==val) return;  // Kein neuer Wert
        if (old>=0 && old<classes.length) {
            el.classList.remove(classes[old])
        }
        if (val>=0 && val<classes.length) {
            el.wert = val
            el.classList.add(classes[val])
        }
    }

    function on(row, col) {
        return !(row<0 || col<0 || row>=rows || col>=cols)
    }

    function get(row, col) {
        if (!on(row, col)) return undefined
        return elements[row][col].wert
    }


    function init_feld() {
        for (let r=0; r<rows; r++) {
            for (let c=0; c<cols; c++) {
                set(r, c, (r==0 || c==0 || r==rows-1 || c==cols-1) ? 5 : 0)
            }
        }
    }

    let snake = {x:0, y:0, // position
                 dir: 0,   // aktuelle Richtung
                 len: 0,   // Länge
                 body: [], // Positionen vom Körper (0 -> Schwanz, len-1 -> Kopf)

                 init : function() {
                    this.x = Math.floor(rows/2)
                    this.y = Math.floor(cols/2)
                    for (this.len=0; this.len<3; this.len++) {
                        let x = this.x-2+this.len
                        let y = this.y
                        set(y, x,1)
                        this.body.push([x, y])
                    }
                    window.addEventListener('keydown', (ev) => {
                        let dir = {'ArrowRight':0, 'ArrowUp':1, 'ArrowLeft':2, 'ArrowDown':3}[ev.key]
                        if (dir !== undefined) {
                            snake.dir = dir
                        }
                    })
                 },

                 step : function(grow=false) { // True, wenn der Schritt gemacht werden kann, false, wenn Unfall                    
                    let x = this.x+dirs[this.dir][0]
                    let y = this.y+dirs[this.dir][1]
                    if (!on([y][x]) || get(y,x)!=0) return false;
                    set(y,x,1);
                    this.x = x
                    this.y = y
                    this.body.push([x,y]);
                    if (!grow) {
                        let [a,b] = this.body.shift()
                        set(b,a,0)
                    }
                    return true;
                 },
    }

    let game_step = 0;
    function game_loop() {
        game_step++;
        if (snake.step(game_step % 2 == 0)) {
            setTimeout(game_loop, 500)
        } else {
            alert("Crash!")
        }
    }

    init_grid(20,20)
    init_feld()
    snake.init()

    game_loop()
})