window.addEventListener('load', function() {

    let rows = 0;
    let cols = 0;
    let elements = [];
    let feld = document.getElementById("feld");
    let colors = ["black", "red", "yellow", "green", "cyan", "blue", "magenta"];
    let classes = []

    function init(r,c) {
        rows = r;
        cols = c;
        feld.style.gridTemplateColumns = `repeat(${cols}, 1fr)`
        for (r=0; r<rows; r++) {
            elements[r] = [];
            for (c=0; c<cols; c++) {
                let div = document.createElement('div');
                div.setAttribute('spalte', c);
                div.setAttribute('zeile', r);
                div.setAttribute('wert', 0);
                // div.classList.add("basic")
                feld.appendChild(div);
                elements[r][c] = div;
                set(r,c,0)
            }
        }
        document.styleSheets[0].insertRule(`#feld div{width:min(${90/cols}vw, ${90/rows}vh);}`)
        colors.forEach((color,i) => {
            let c = `feld${color}`
            classes.push(c);
            document.styleSheets[0].insertRule(`.${c} { background-color:${color};}`)
        })
    }

    function set(row, col, val) {
        if (!on(row, col)) return; // Ausserhalb vom Feld
        let el = elements[row][col]
        let old = el.wert
        if (old==val) return;  // Kein neuer Wert
        if (old>=0 && old<classes.length) {
            el.classList.remove(classes[old])
        }
        if (val>=0 && val<classes.length) {
            el.wert = val
            el.classList.add(classes[val])
        }
    }

    function on(row, col) {
        return !(row<0 || col<0 || row>=rows || col>=cols)
    }

    function get(row, col) {
        if (!on(row, col)) return undefined
        return elements[row][col].wert
    }


    function demo(offset=1000.0) {
        for (let r=0; r<rows; r++) {
            for (let c=0; c<cols; c++) {
                d = Math.floor(offset+0.37*Math.sqrt(Math.pow(c-cols/2,2)+Math.pow(r-rows/2,2))) % colors.length;
                set(r,c,d)
            }
        }
        setTimeout(()=>{demo(offset-0.031)}, 100)
    }

    init(20,20);
    demo();
})