import importlib
from board import Board
from game import Game
import glob
import os
# der gifmaker braucht python3 und convert (ImageMagick) auf der Kommandozeile
#import gifmaker
import time

class Tournament:

    def __init__(self, stratfiles):
        self.stratclasses = []
        for stratfile in stratfiles:
            s = importlib.import_module(stratfile[0:-3])
            clname = [x for x in dir(s) if x[-8:]=="Strategy" and len(x)>9]
            clname = clname[0]
            stratclass = getattr(s, clname)
            self.stratclasses.append(stratclass)
        self.stats = [0 for s in self.stratclasses]
        self.runs = 0
        self.total = 1
        for i in range(len(stratfiles), len(stratfiles)-4,-1):
            self.total*=i

        
    def run(self, used=None, remain=None):
        if used == None:
            used = []
            remain = list(range(len(self.stratclasses)))
            self.startTime = time.time()
    
        if len(used)==4:  # Run game
            board = Board(30,20)
            strats = [self.stratclasses[i] for i in used]
            print("-"*80)
            print(", ".join([str(s) for s in strats]))
            game = Game(board, strats, False, False)  # Letzter Parameter auf True damit gifs generiert werden (nur Linux)
            res = game.run()
            for i in range(4):
                self.stats[used[i]] += res[i]
            print(res)
            print([game.params[i].reason for i in range(game.n)])
            self.runs+=1
            print("Completed %d of %d runs" % (self.runs, self.total))
            elapsed = time.time()-self.startTime
            print("Time elapsed: %f seconds" % elapsed)
            estimate = time.time()+elapsed/self.runs*(self.total-self.runs)
            print("ETA : " + time.strftime("%a, %d %b %Y %H:%M:%S +0000",time.localtime(estimate)))

        else:
            for s in remain:
                u = used+[s]
                r = [x for x in remain]
                r.remove(s)
                self.run(u,r)

    def makeGifPages(self):
        for d in glob.glob(gifmaker.GifMaker.dirname+"/*"):
            if os.path.isdir(d):
                html = "<!DOCTYPE html><html><body><head><style>img { image-rendering: pixelated;}</style></head><h1>Die letzen Momente von "+d+" in rot.</h1>"
                for gif in glob.glob(d+"/*.gif"):
                    gif = os.path.basename(gif)
                    html+="<img width='240' height='160' src='"+gif+"'>"
                html += "</body></html>\n"
                f = open(d+"/index.html", "w")
                f.write(html)
                f.close()





strats = ["ivo_simple_strategy.py",
        "ivo_simple_strategy.py",
        "ivo_simple_strategy.py",
        "ivo_simple_strategy.py",
        ]


t = Tournament(strats)
t.run()
#t.makeGifPages()

print("="*80)
print("="*80)
print(strats)
print(t.stats)

#f = open(gifmaker.GifMaker.dirname+"/results.txt", "a")
#f.write(str(strats)+"\n")
#f.write(str(t.stats)+"\n")
#f.close()

