
import params
Params = params.Params


class Strategy:
    """Basis-Klasse fuer eine Strategie
    
    Attributes:
        params (Params): Aktueller Spielzustand fuer diese Strategie. Dieser darf nur gelesen, aber
            nicht geschrieben werden. Der aktuelle Spielzustand wird von der Game Klasse geschrieben.
            
    """
    def __init__(self, width,height):
        """Args:
            width (int): Breite des Felds
            height (int): Hoehe des Felds
        """
        self.params = Params(width,height)
        
        
    def getParams(self):
        return self.params
    
    def getDir(self):
        """Aus dem aktuellen Spielstand soll die Richtung fuer den naechsten Zug errechnet werden.
        
        Returns:
            Richtung (int) 0 bis 3, Richtung in 90-grad Schritten, trigonometrisch
                0=rechts
                1=unten
                2=links
                3=oben
        """
        return self.params.dir
    
    