import socket

import board
Board = board.Board

import params
Params = params.Params

import strategy
Strategy = strategy.Strategy

import random

import ast


class NetworkStrategy(Strategy):
    """Ganz einfache Beispiel-Klasse einer Strategie.

    Attributes:
        params (Params): Aktueller Spielzustand fuer diese Strategie. Dieser darf nur gelesen, aber
            nicht geschrieben werden. Der aktuelle Spielzustand wird von der Game Klasse geschrieben."""
    
    def __init__(self, width,height):
        """Args:
            width (int): Breite des Felds
            height (int): Hoehe des Felds
        """
        Strategy.__init__(self, width,height)
        # Hier koennen weitere Variablen fuer diese Strategie initialisiert werden
        # z.B.
        # self.einsatzProzent = 120
        self.client = socket.socket(socket.AF_INET, socket.SOCK_STREAM)
        self.client.connect(("tech-lab.ch", 40198))
        strats = self.client.recv(2048)
        if strats == b'':
            raise "Fehler: Keine Liste der Strategien erhalten"
        strats = strats.split("\t")
        for i,s in enumerate(strats):
            print("[%d] %s" % (i,s))
        c = 0
        while True:
            c = raw_input("Nummer der Strategie: ")
            c = int(c)
            if (c>=0 and c<len(strats)):
                break
        self.client.send(str(c)+"\n")
        self.client.send("%d\t%d\n" % (width, height))
        
            
        
        
        
    def getDir(self):
        """Aus dem aktuellen Spielstand soll die Richtung fuer den naechsten Zug errechnet werden.
        
        Returns:
            Richtung (int) 0 bis 3, Richtung in 90-grad Schritten, trigonometrisch
                0=rechts
                1=unten
                2=links
                3=oben
        """
        serparam = repr(self.params.__dict__)
        print("Sending params")
        self.client.send(serparam+"\n")
        d = self.client.recv(2048)
        print("Got "+d)
        d = int(d)
        return d
    
    