from board import Board
import png
import random
import os

class GifMaker:
    
    palette = [(255,0,0), (0,255,0), (0,0,255), (150,0,150), (0,0,0), (200,200,0),(255,255,255)]
    dirname = "tournament.nosync" 

    def __init__(self):
        self.nr = 0


    def makeGif(self, player, startindex, name, felder):
        if startindex>len(felder):
            startindex = 0
        umrech = list(range(1,4))
        umrech.insert(player,0)
        files = []
        os.system("mkdir -p "+self.dirname)
        for i in range(len(felder)):
            feld = felder[(i+startindex)% len(felder)]
            pixels = []
            for y in range(len(feld[0])):
                pixels.append([])
                for x in range(len(feld)):
                    f = feld[x][y]
                    if f==Board.APPLE:
                        pixels[-1].append(5)  
                    elif f==Board.WALL:
                        pixels[-1].append(4) # Black
                    else:
                        if f%10>0:
                            pixels[-1].append(umrech[f%10-1])
                        else:
                            pixels[-1].append(6) # White
            filename = self.dirname+"/t%03d.png" % i
            files.append(filename)
            w = png.Writer(len(pixels[0]), len(pixels), palette=self.palette, bitdepth=4)
            f = open(filename, 'wb')
            w.write(f,pixels)
            f.close()
        filename = self.dirname+"/"+name+"/"+str(random.randrange(1000000,10000000))+".gif"
        cmd = "mkdir -p "+self.dirname+"/"+name+"; convert -delay 20 "+self.dirname+"/t[0-9][0-9][0-9].png -loop 0 "+filename
        #print(cmd)
        os.system(cmd)
        cmd = "rm -f "+self.dirname+"/t[0-9][0-9][0-9].png"
        #print(cmd)
        os.system(cmd)



