import socketserver
import glob
import importlib
import sys
import ast

# import Strategy

port=40198



class ConnectionHandler(socketserver.StreamRequestHandler):
    def handle(self):
        files = glob.glob("*_strategy.py")
        if "network_strategy.py" in files:
            files.remove("network_strategy.py")
        # self.request is the TCP socket connected to the client
        print(b"Connection, sending list")
        self.request.sendall(bytearray("\t".join(files), "utf-8"))
        print(b"Sent list of strategies")
        
        # Read choice and get class
        data = self.rfile.readline().strip()
        if data==b"":
            print("Closing connection")
            self.request.close()
            return
        print(b"Client wants "+data)
        data = int(data)
        if (data<0 or data>=len(files)):
            raise "No can do..."
        stratfile = files[int(data)].encode("utf8")
        print(b"startfile is "+stratfile)
        stratfile = stratfile[0:-3].decode("utf8")
        print(stratfile)
        s = importlib.import_module(stratfile)
        clname = [x for x in dir(s) if x[-8:]=="Strategy" and len(x)>9]
        print(clname)
        clname = clname[0]
        print(clname)
        strat = getattr(s, clname)
        print(strat)
        # Read size and instanciate
        data = self.rfile.readline().strip().decode("utf-8")
        print("Size "+data)
        data = data.split("\t")
        print(data)
        strategy = strat(int(data[0]), int(data[1]))
        print(strategy)
        
        # Game loop
        while True:
            # Read params blob
            data = self.rfile.readline().strip()
            if data==b"":
                print("Closing connection")
                self.request.close()
                break
            # Parse blob
            res = ast.literal_eval(data.decode("utf-8"))
            # Set params object
            for key in res:
                setattr(strategy.params, key, res[key])
            d = strategy.getDir()
            print(" -> result "+str(d))
            self.request.sendall(bytearray(str(d)+"\n","utf-8"))
        


socketserver.TCPServer.allow_reuse_address = True        
with socketserver.TCPServer(("", port), ConnectionHandler) as server:
    # Activate the server; this will keep running until you
    # interrupt the program with Ctrl-C
    server.serve_forever()
