from gpanel import *

import board
Board = board.Board


class SnakeGraphics:

    SIZE=16
    
    def __init__(self,feld):
        self.w = len(feld)
        self.h = len(feld[0])
        makeGPanel(Size(SnakeGraphics.SIZE*self.w, SnakeGraphics.SIZE*self.h))
        window(0,SnakeGraphics.SIZE*self.w,SnakeGraphics.SIZE*self.h,0)
        colors = [makeColor(255,0,0), makeColor(0,255,0), makeColor(0,0,255), makeColor(200,0,200)]
        gray = makeColor(128,128,128)
        values = [10,20,30,40,100,200,300,400,500,600,1000,2000]
        paths = ["pngs/"+str(i)+".png" for i in values]
        self.imgs = [[SnakeGraphics.replaceRGB(getImage("pngs/"+str(i)+".png"), gray, c) for i in values] for c in colors]
#        self.imgs = [[getImage(p) for p in paths] for c in colors]
        
        self.imgmap = {values[i]:i for i in range(len(values))}
        bgColor("white")
        clear()
        for x in range(self.w):
            for y in range(self.h):
                if feld[x][y]!=Board.EMPTY:
                    self.draw(x,y,feld[x][y])
        
    @staticmethod
    def replaceRGB(img,src,dst):
        for x in range(img.getWidth()):
            for y in range(img.getHeight()):
                if img.getPixelColor(x,y)==src:
                    img.setPixelColor(x,y,dst)
        return img
            
            
    def dispose(self):
        dispose()
        
    def draw(self, x,y,what):
        w = SnakeGraphics.SIZE
        x*=w
        y*=w
        if what==Board.APPLE or what==Board.WALL:
            image(self.imgs[0][self.imgmap[what]],x,y+w-1)
        elif what==Board.EMPTY:
            setColor("white")
            fillRectangle(x, y, x+w, y+w)
        else:
            s = what % 10-1
            img = self.imgmap[what - s - 1]
            image(self.imgs[s][img],x,y+w-1)
        
    