
class Params:
    """Speichert den Spielzustand fuer einen Spieler.
    
    Attributes:
        width (int): Breite des Spielfelds
        height (int): Hoehe des Spielfelds
        feld (int[width][height]): Aktueller Zustand des Felds
        vanish (int[width][height]): Bis wann ein Feld noch besetzt ist.
        alive (bool): Ob die Schlange noch am Leben ist.
        points (int): Punkte des Spielers
        time (int): Aktuelle Zeit (in Spielschritten)
        appletime (int): Zeit, zu welcher der Apfel verfault (und alle Schlangen sterben).
        x (int): x-Koordinate der Schlange
        y (int): y-Koordinate der Schlange
        dir (int): Letzte Richtung der Schlange
        reason (str): Todesursache
        changed (int[][2]): Koordinaten der Felder, wo eine Veraenderung stattgefunden hat.
        heads (int[][2]): Koordinaten der aller lebenden Schlangenkoepfe (auch des eigenen)
        apple (int[2]): Koordinaten des Apfels
    """
    def __init__(self, width, height):
        """Args:
            width (int): Breite des Felds
            height (int): Hoehe des Felds
        """
        self.width=width
        self.height=height
        self.feld = [[0 for i in range(0,height)] for j in range(0,width)]
        self.vanish = [[0 for i in range(0,height)] for j in range(0,width)]
        self.alive = True
        self.points = 0
        self.time = 0
        self.x = 0
        self.y = 0
        self.dir = 0
        self.reason = "Still alive!"
        self.appletime = 0
        self.changed = []
        self.heads = []
        self.apple = [-1,-1]
        