"""Beispiel fuer eine ganz simple Strategie"""

import board
Board = board.Board

import params
Params = params.Params

import strategy
Strategy = strategy.Strategy

import random


class IvoSimpleStrategy(Strategy):
    """Ganz einfache Beispiel-Klasse einer Strategie.

    Attributes:
        params (Params): Aktueller Spielzustand fuer diese Strategie. Dieser darf nur gelesen, aber
            nicht geschrieben werden. Der aktuelle Spielzustand wird von der Game Klasse geschrieben."""
    
    def __init__(self, width,height):
        """Args:
            width (int): Breite des Felds
            height (int): Hoehe des Felds
        """
        Strategy.__init__(self, width,height)
        # Hier koennen weitere Variablen fuer diese Strategie initialisiert werden
        # z.B.
        # self.einsatzProzent = 120
        
        
    def getDir(self):
        """Aus dem aktuellen Spielstand soll die Richtung fuer den naechsten Zug errechnet werden.
        
        Returns:
            Richtung (int) 0 bis 3, Richtung in 90-grad Schritten, trigonometrisch
                0=rechts
                1=unten
                2=links
                3=oben
        """
        # Letzte Richtung ermitteln
        d = self.params.dir
        
        # Aktuelle Position ermitteln
        x,y = self.params.x, self.params.y
        # print("(x,y)=(%d,%d)  d=%d" % (x,y,d))
        
        # Position, wenn in die gleiche Richtung weiter gegangen wuerde
        a,b = Board.move(x,y,d)        
        
        # print("(a,b)=(%d,%d)" % (a,b))
        # print("   feld[a][b] = %d" % self.params.feld[a][b])
        # Wenn Apfel, go for it!
        if self.params.feld[a][b]==Board.APPLE:
            return d
        # Wenn naechste Position nicht frei (oder in 10% der Faelle)
        if self.params.feld[a][b]!=Board.EMPTY or random.randint(0,10)==0:
            # im Uhrzeigersinn drehen
            d=(d+1+2*random.randint(0,1))%4
            # Neue naechste Position ermitteln
            a,b = Board.move(x,y,d) 
            # Wenn Apfel, go for it!
            if self.params.feld[a][b]==Board.APPLE:
                return d
            # Wenn auch besetzt
            if self.params.feld[a][b]!=Board.EMPTY:
                # 2x im Gegenuhrzeigersinn, wenn es da auch nicht frei ist, ist sowieso fertig
                return (d+2)%4;
        # Richtung zurueckgeben
        return d        
        