
class Board:
    """ Standardspielbrett

    Kann fuer kompliziertere Bretter vererbt werden.
    
    Eintraege: Summe aus
    1-4 Nummer der Schlange
    10-40 (Kopf mit Richtung 10*(d+1))
    100-600 (Koerper -,|,r,7,_|,L )
    1000,2000 (Mauer, Apfel)
    
    Attributes:
        width (int): Breite
        height (int): Hoehe
        feld : Array mit width * height Integer Eintraegen.
        startPos: Array mit 4 Eintraegen [x,y,dir] mit Startpositionen und Richtung
    """

    EMPTY=0 
    """Leeres Feld"""
    WALL=1000 
    """Mauer"""
    APPLE=2000 
    """Apfel"""
    
    VECS=[[1,0],[0,1],[-1,0],[0,-1]]
    """Vektoren die zu den Richtungen gehoeren"""
    
    def __init__(self, width, height):
        """Macht ein leeres Spielfeld mit eine Mauer rundherum
        
        Args:
            width (int): Breite
            height (int): Hoehe
        """
        self.width=width;
        self.height=height;
        self.feld=[[Board.EMPTY for i in range(0,height)] for j in range(0,width)]
        for i in range(0,width):
            self.feld[i][0]=Board.WALL
            self.feld[i][height-1]=Board.WALL
        for j in range(0,height):
            self.feld[0][j]=Board.WALL
            self.feld[width-1][j]=Board.WALL
        self.startPos = [[4,4,0],[width-4,4,1],
                        [4,height-4,3],[width-4,height-4,2]]

    @staticmethod
    def bodyEntry(olddir, dir):
        if (olddir==dir):
            return (dir%2+1)*100
        if olddir==0:
            if dir==1:
                return 400
            return 500
        elif olddir==1:
            if dir==0:
                return 600
            return 500
        elif olddir==2:
            if dir==1:
                return 300
            return 600
        if dir==0:
            return 300
        return 400
            
                        
    @staticmethod
    def move(x,y,d):
        """Berechnet die neuen Koordinaten, wenn von (x,y) in Richtung d gegangen wird.
        
        Beispiel: 
        a,b=Board.move(4,5,1)
        liefert 4,6 in a,b (d=1 heisst nach unten)
        
        Args:
            x (int): x-Koordinate
            y (int): y-Kooridnate
            d (int): Richtung (0-3)
            
        Returns:
            a,b (int,int): Neue Koordinaten
        """
            
        return x+Board.VECS[d][0],y+Board.VECS[d][1]
                
    @staticmethod
    def str(feld):
        """Konvertiert ein Feld in einen String (ist wohl ineffizient)
        
        Args:
            feld (int[][]): zweidimensionales Array 
            
        Returns:
            Stringdarstellung des felds, inkl. Zeilenumbrueche
        """
        w = len(feld)
        h = len(feld[0])
        r = ""
        for y in range(0,h):
            for x in range(0,w):
                if feld[x][y]==Board.WALL:
                    r+="##"
                elif feld[x][y]==Board.EMPTY:
                    r+="  "
                elif feld[x][y]==Board.APPLE:
                    r+="()"
                else:
                    s = feld[x][y]
                    if (s>=10 and s<100):
                        r += ['>>','vv', '<<', '^^'][s//10-1]
                    else:
                        r += str(feld[x][y]%10)*2
            r+="\n"
        return r