

class Laby:
    """Klasse, die ein Raster von Zellen in ASCII-Art darstellt und manipulieren kann."""
    def __init__(self,w:int,h:int) -> None:
        """
            
        """
        self.w = w
        self.h = h
        self.dirs = [[1,0],[0,1],[-1,0],[0,-1]]
        self.neu()

    def load(self,datei):
        with open(datei, "r") as f:
            self.lines = [l.strip() for l in f.readlines()]
        self.w = len(self.lines[0])//4
        self.h = len(self.lines)//2

    def save(self,datei):
        with open(datei, "w") as f:
            f.write("\n".join(self.lines))

    def neu(self) -> None:
        self.lines = []
        border = "+---"*self.w+"+"
        row = "|   "*self.h+"|"
        for i in range(self.h):
            self.lines.append(border)
            self.lines.append(row)
        self.lines.append(border)

    def __str__(self) -> str:
        return "\n".join(self.lines)

    def getMark(self,x:int,y:int) -> str:
        return self.lines[y*2+1][x*4+2]
    
    def move(self,x,y,d) -> list[int]:
        return x+self.dirs[d][0], y+self.dirs[d][1]

    def setMark(self,x:int,y:int,c:str) -> None:
        pos = x*4+2
        l = self.lines[y*2+1]
        self.lines[y*2+1] = l[:pos]+c+l[(pos+1):]

    def on(self,x:int,y:int) -> bool:
        return x>=0 and x<self.w and y>=0 and y<self.h

    def canGo(self, x:int,y:int,d:int) -> bool:
        if not self.on(x,y):
            return False
        a,b = self.move(x,y,d)
        if not self.on(a,b):
            return False
        y=y*2+1+self.dirs[d][1]
        x=x*4+2 + self.dirs[d][0]*2
        return self.lines[y][x]==" "

    def setGo(self, x:int,y:int,d:int,connected=True) -> None:
        if not self.on(x,y):
            return
        a = x+self.dirs[d][0]
        b = y+self.dirs[d][1]
        if not self.on(a,b):
            return
        y=y*2+1+self.dirs[d][1]
        x=x*4+2 + self.dirs[d][0]*2
        l = self.lines[y]
        if d%2==0:
            connected = " " if connected else "|"
            self.lines[y] = l[:x] + connected + l[(x+1):]
        else:
            connected = "   " if connected else "---"
            self.lines[y] = l[:(x-1)] + connected + l[(x+2):]
        



