import { makeblock, block2svg, blockWidth, blockHeight } from "./svgbuilder.js";

class Block {
    constructor(x,y) {
        let classname = "block" + ((x+y)%2+1)
        this.el = makeblock(x,y, classname);
        this.x = x;
        this.y = y;
        [this.a, this.b] = block2svg(x,y);
        this.w = blockWidth;
        this.h = blockHeight;
    }
}

class Blocks {
    constructor(rows) {
        // Platz für 10 Spalten
        this.rows = rows
        this.blocks = new Array(10).fill(0).map(e=>new Array(rows).fill(null));
        for (let x=0; x<10; x++) {
            // Spaltenweise füllen
            for (let y=0; y<this.rows; y++) {
                this.blocks[x][y] = new Block(x,y);
            }
        }
    }

    // x,y,r sind svg-Koordinaten des Balls
    // gibt null zurück, wenn keine Block-Kollision, sonst das Entsprechende Block-Element
    collision(ball) {
        let {x,y,r} = ball;
        // Alle Blöcke durchgehen
        for (let bx=0; bx<10; bx++) {
            for (let by=0; by<this.rows; by++) {
                if (this.blocks[bx][by]) { // Nur wenn da schon ein Block ist
                    // Eckpunkt, Breite Höhe vom Block
                    let {a,b,w,h} = this.blocks[bx][by]
                    // TODO: Test, ob Ball mit Block kollidiert, 
                    
                    // Falls Kollision: return this.blocks[bx][by];
                }
            }
        }
        // Keine Kollision gefunden
        return null;
    }

    // Block entfernen (vom SVG und dem Blocks-Objekt)
    remove(block) {
        this.blocks[block.x][block.y] = null;
        block.el.remove();
    }

}

class Ball {
    constructor() {
        this.ball = document.getElementById('ball');
        this.vx = (Math.random()*10-5);
        this.vy = -50;        // Units per second
        this.r = 4;
        this.setPosition(160,180);
    }

    setPosition(x,y) {
        this.x = Number(x);
        this.y = Number(y);
        this.ball.setAttribute('x', this.x);
        this.ball.setAttribute('y', this.y);
    }

    move(dt) {
        // TODO
        // neuer Koordinaten etc ausrechnen, mit this.setPosition(..., ...) setzen
    }

    // TODO
    // Eventuelle Kollisionen mit den Aussenwänden ausführen. Evtl. Position ebenfalls neu setzen
    borderCollisions() {
        // Koordinaten vom Ball
        let {x,y,r} = this;
    }

    // TODO
    // Kollision mit gegebenem Block ausführen, Geschwindigkeiten this.vx, this.vy neu setzen, evtl. Position ebenfalls neu setzen
    collideWithBlock(block) {
        let [x,y,r] = [this.x, this.y, this.r];
        let [a,b,w,h] = [block.a, block.b, block.w, block.h];
    }

    // TODO
    // Kollision mit Paddle ausführen
    collideWithPaddle(paddle) {
        if (this.y+this.r>paddle.y && this.x+this.r>paddle.x && this.x-this.r<paddle.x+paddle.w) {
            let v = Math.sqrt(this.vx*this.vx+this.vy*this.vy);
            this.y = paddle.y-this.r
            let a = (this.x-(paddle.x+paddle.w/2))/paddle.w;
            this.vy = -Math.cos(a)*v;
            this.vx = Math.sin(a)*v;
        }
    }
}

class Paddle {
    constructor() {
        this.paddle = document.getElementById('paddle');
        this.x = 145; 
        this.y = 220;
        this.w = 30;
        this.vx = 0;
    }
    move(dt) {
        //Todo: Restrain position
        this.setPosition(this.x + this.vx*dt, this.y);
    }
    setPosition(x,y) {
        this.x = Number(x);
        this.y = Number(y);
        this.paddle.setAttribute('x', this.x);
        this.paddle.setAttribute('y', this.y);
    }
}

export {Blocks, Ball, Paddle}