import { Blocks, Ball, Paddle } from "./objects.js";


window.addEventListener('load', function() {

    let blocks = new Blocks(5);
    let ball = new Ball();
    let paddle = new Paddle();

    let lastTime = null;

    // See also https://developer.mozilla.org/en-US/docs/Web/API/window/requestAnimationFrame
    function gameLoop(timeNow) {
        let dt = 0;
        if (lastTime!==null) {
            dt = (timeNow-lastTime)/1000;
        }
        lastTime = timeNow;
        
        // Bewegungen ausführen
        ball.move(dt);
        paddle.move(dt);

        // Kollisionen testen
        ball.borderCollisions();
        let block = blocks.collision(ball);
        if (block) {
            ball.collideWithBlock(block);
            blocks.remove(block);
        }
        ball.collideWithPaddle(paddle);

        // Nächstes Frame
        requestAnimationFrame(gameLoop)
    }

    // Callback-Funktionen für User-Input
    function startKeyboard(ev) {
        if (ev.code=="ArrowRight") {
            paddle.vx=100;
        }
        if (ev.code == "ArrowLeft") {
            paddle.vx=-100;
        }
    }
    function stopMove(ev) {
        paddle.vx = 0;
    }

    function startMouse(ev) {
        ev.preventDefault();
        if (ev.clientX<document.body.getBoundingClientRect().width/2) {
            paddle.vx=-100;
        } else {
            paddle.vx=100;
        }
    }

    function startTouch(ev) {
        ev.preventDefault();
        console.log(ev);
        if (ev.touches[0].clientX<document.body.getBoundingClientRect().width/2) {
            paddle.vx=-100;
        } else {
            paddle.vx=100;
        }
    }

    // Callbacks registrieren
    window.addEventListener('keydown', startKeyboard);
    window.addEventListener('keyup', stopMove);
    
    window.addEventListener('mousedown', startMouse);
    window.addEventListener('mouseup', stopMove);
    
    window.addEventListener('touchstart', startTouch);
    window.addEventListener('touchmove', startTouch);
    window.addEventListener('touchcancel', stopMove);
    window.addEventListener('touchend', stopMove);

    // Spiel starten
    requestAnimationFrame(gameLoop)
});