# -*- coding: utf8 -*-

from parser import Parser
from vector import Vector
from bbox import BBox
from transform import Transform
from plotter import Plotter



# Koordinatensystem auf dem Whiteboard in mm:
#  (0,0)----------(2000,0)
#   |_____max 600_____|
#   |                 |
#   |                 |
#   |   (1000,1075)   |
# (0,1300)-------(2000,1300)
#
# Startposition (Motoren-Nullpunkt) des Plotters bei 
# r1 = 1445, r2=1445 -> (1000,1075)
# Motoren bei (35,0) und (1965,0)
#


def umrechnen(v):
    m1 = Vector([35,0])
    m2 = Vector([1965,0])
    r1 = (m1-v).length-1445
    r2 = (m2-v).length-1445
    r1 /= 0.0157029
    r2 /= 0.0157029
    return (int(r1), int(r2))
    

datei = "techlab-simp.svg"
target = BBox( (Vector([900,1000]), Vector([1100,1000])) )
#target = BBox( (Vector([400,1075]), Vector([1600,1075])) )

parser = Parser(datei)
kurven = parser.kurven
print(kurven)
origbbox = kurven.getBBox()
transform = Transform(origbbox,target)
boardkurven = transform*kurven
print("Bounding Box der transformierten Kurve")
boardbbox = boardkurven.getBBox()
print(boardbbox)
if (boardbbox.pts[0]<100 or boardbbox.pts[1].x>1900 or boardbbox.pts[0].y<600 or boardbbox.pts[1].y>1075):
    raise BaseException("Kurven auserhalb des erlaubten Bereichs!")



plotter = Plotter()

#plotter.linie(Vector((0,1075)),Vector((2000,1075)))
#plotter.linie(Vector((1000,0)),Vector((1000,1300)))

f = open("out.gcode", "w")

for k in boardkurven.kurven:
    pts = k.ptList(1)  # 1mm Auflösung
    m1,m2 = umrechnen(pts[0])
#    plotter.realisticTo(m1,m2)
    f.write("G1 X%d Y%d\n" % (m1, m2))
    f.write("G1 Z1\n")
    plotter.penDown();
    for i in range(1,len(pts)):
        plotter.linie(pts[i-1], pts[i])
        m1,m2 = umrechnen(pts[i])
#        plotter.realisticTo(m1,m2)
        f.write("G1 X%d Y%d\n" % (m1, m2))
    plotter.penUp();
    f.write("G1 Z0\n")
    
plotter.realisticTo(0,0)
f.write("G1 X0 Y0\n")     

f.close()
