import serial
import fileinput
import time


def readall(p):
    return p.read(999)


def emptyBuffer(p):
    res = ""
    while True:
        r = readall(p)
        if len(r)==0:
            return res
        res += r

def ack(p, timeout=30):
    r = ""
    ende = time.time()+timeout
    while (time.time()<ende):
        r += emptyBuffer(p)
        #print("So far: "+r)
        #print("End is ->"+r[-3:]+"<-")
        if r[-3:]==b"OK\n":
            return r
    return r



p = serial.Serial('/dev/ttyUSB5', 115200, timeout=0) 

time.sleep(3)
print("emptyBuffer:")
print(emptyBuffer(p))

for line in fileinput.input():
    print ("Read line ->"+line+"<-")
    line = line.rstrip()  # Remove trailing line ending
    if len(line)>0 and line[0]!="(" and line[0]!="%":
        print("Sending ->"+line+"<-")
        p.write(line+b"\n")
        print(ack(p))

p.close()



