# -*- coding: utf8 -*-

from bbox import BBox

        
class Bezier:
    
    def __init__(self,pts):
        self.n = len(pts)
        self.pts = [p.copy() for p in pts]


    # Ungefähre BBox (kann zu gross sein)    
    def getBBox(self):
        return BBox(self.pts)


    # Letzter Kontrollpunkt
    def lastCTR():
        return self.pts[-2]
    
    # Transformiert alle Punkte 
    def transform(self, t):
        self.pts = [t*p for p in self.pts]
        return self
    
    def copy(self):
        return Bezier(self.pts)
    

    # TODO
    # Kurvenpunkt zum Parameter t berechnen
    def at(self, t):
        if self.n==2:
            return (1-t)*self.pts[0]+t*self.pts[1]
        elif self.n==3:
            return (1-t)**2*self.pts[0] + 2*(1-t)*t*self.pts[1] + t*t*self.pts[2]
        elif self.n==4:
            return (1-t)**3*self.pts[0] + 3*(1-t)**2*t*self.pts[1] + 3*(1-t)*t*t*self.pts[2] + t**3*self.pts[3]
    
    
    # Liefert eine Folge von Punkten auf der Kurve, 
    # die höchstens maxdist voneinander entfernt sind.
    # Der letzte Punkt ist wahlweise dabei oder nicht,
    # Das interval für t kann gewählt werden.
    def ptList(self, maxdist, mitLetztem=True, interval=(0,1)):
        #print(interval)
        # Punkte am Rand von Intervall
        pt0 = self.at(interval[0])
        pt1 = self.at(interval[1])
        if ((pt0-pt1).length < maxdist):
            if mitLetztem:
                return (pt0, pt1)
            else:
                return (pt0,)
        else:
            m = (interval[1]+interval[0])/2
            return self.ptList(maxdist, False, (interval[0], m))+self.ptList(maxdist, mitLetztem, (m, interval[1]))
            

      

    def __str__(self):
        res = "Bezier n=%d " % self.n  
        for p in self.pts:
            res += str(p)
        return res
