# -*- coding: utf8 -*-

from vector import Vector

class BBox:
    # Array von Punkten
    def __init__(self, pts):
        xmin = min([p.x for p in pts])
        ymin = min([p.y for p in pts])
        xmax = max([p.x for p in pts])
        ymax = max([p.y for p in pts])
        self.pts = [Vector((xmin, ymin)), Vector((xmax, ymax))]
        #print(self)
        
    def __str__(self):
        return "BBox min="+str(self.pts[0])+" to "+str(self.pts[1])

    # Breite der BBox
    def w(self):
        return self.pts[1].x-self.pts[0].x
    
    # Höhe der BBox
    def h(self):
        return self.pts[1].y-self.pts[0].y

    # (Min,Max)-Punkt der BBox
    def origin(self):
        return Vector((self.pts[0].x, self.pts[1].y))
            
    # Vereinigung der BBoxen (BBox + BBox -> BBox)
    def __add__(self, other):
        if (other==None):
            return self
        return BBox((self.pts+other.pts))

    def __str__(self):
        return "BBox %s -> %s" % (str(self.pts[0]), str(self.pts[1]))
