# -*- coding: utf-8 -*-

# Dieses Modul sollte einen Teil der Vector-Klasse von
# https://docs.blender.org/api/current/mathutils.html
# implementieren. Diese (sehr) alte Dokumentation ist etwas uebersichtlicher (und wohl noch gueltig):
# https://docs.blender.org/api/249PythonDoc/Mathutils.Vector-class.html

class Vector:
    
    def __init__(self,v=(0,0,0)):
        self.v = [x for x in v]
        if len(self.v) == 2:
            self.v.append(0)
        self.x = self.v[0]
        self.y = self.v[1]
        self.z = self.v[2]
        self.length=self.dot(self)**0.5
        
        
    def cross(self, other):
        return Vector([self.v[1]*other.v[2]-self.v[2]*other.v[1],
                       self.v[2]*other.v[0]-self.v[0]*other.v[2],
                       self.v[0]*other.v[1]-self.v[1]*other.v[0]])
    def copy(self):
        return Vector(self)                

    def __getitem__(self, i):
        return self.v[i]
                                                
    def dot(self, other):
        return self.v[0]*other.v[0]+\
               self.v[1]*other.v[1]+\
               self.v[2]*other.v[2]
    
  
    def __mul__(self, num):
        return Vector([self.v[0]*num, self.v[1]*num, self.v[2]*num])

    __rmul__ = __mul__

    def __div__(self, num):
        return self*(1.0/num)
    
    __truediv__ = __div__

    def __add__(self, other):
        return Vector([self.v[0]+other.v[0], self.v[1]+other.v[1], self.v[2]+other.v[2]])
    
    def __sub__(self, other):
        return self+other.negate()
        
    def negate(self):
        return self*-1.0

    def normalize(self):
        return self/self.length
    
    def normalized(self):
        return self.normalize()
    
    def __str__(self):
        return "(%f, %f, %f)" % (self.v[0], self.v[1], self.v[2])
    
 
    
if __name__ == "__main__":
    a = Vector([2,3,-1])
    print(a)
    b = Vector([-1,2,5])
    print(b)    
    print("Sum: "+str(a+b))
    print(a.dot(b))
    c=a.cross(b)
    print(c)
    d = c.copy()
    print(d)
    print(a.dot(c))
    print(b.dot(c))
    
    