# -*- coding: utf8 -*-

from vector import Vector
from bbox import BBox

class Transform:
    # Lokaler import, sonst gibt es zirkuläre Abhängigkeiten
    from kurven import Kurven
    from kurve import Kurve
    from bezier import Bezier
    def __init__(self, streck_or_bbox1, trans_or_bbox2):
        if isinstance(streck_or_bbox1, (int, long, float)) and isinstance(trans_or_bbox2, Vector):
            self.streck = streck_or_bbox1
            self.trans = trans_or_bbox2
        elif isinstance(streck_or_bbox1, BBox) and isinstance(trans_or_bbox2, BBox):
            self.streck = trans_or_bbox2.w()/streck_or_bbox1.w()
            self.trans = trans_or_bbox2.origin() - self.streck*streck_or_bbox1.origin()
        else:
            raise BaseException("Transform wird mit Streckfaktor und Verschiebungsvektor oder mit zwei Boundingboxen initialisiert!")
            
        
    # Erlaubt die Notation Transform * Vector, was den transformierten Vektor liefert
    #
    # Zusätzlich ist es möglich, Transform * Transform zu schreiben, wobei die 
    # Transformation erhalten wird, wenn **die zweite** Transformation zuerst
    # angewendet wird (ganz im Sinne von f(g(x))
    #
    # Transform * Kurven, Kurve oder Bezier geht auch, erzeugt ein neues Objekt
    
    def __mul__(self, other):
        if isinstance(other, Transform):
            return Transform(self.streck*other.streck, self.streck*other.trans+self.trans)
        elif isinstance(other, Vector):
            return self.streck*other+self.trans
        elif isinstance(other, Transform.Kurven) or isinstance(other, Transform.Kurve) or isinstance(other, Transform.Bezier):
            return other.copy().transform(self)
        else:
            raise BaseException("Keine Ahnung was Transform * "+str(type(other))+" ergeben soll...")

        
    def __str__(self):
        return "Trans l=%f, t=%s" % (self.streck, str(self.trans))        

if __name__ == "__main__":
    a = Vector([2,-3])
    t = Transform(2,Vector([100,100]))
    t2 = Transform(2, Vector([0,0]))
    print(a)
    print(t*a)
    print(t2*a)
    print(t*t2*a)
    print(t2*t*a)
    
    b1 = BBox((Vector([1,2]), Vector([4,5])))
    b2 = BBox((Vector([0,0]), Vector([10,10])))
    print(b1)
    print(b2)
    t3 = Transform(b1,b2)
    print(t3)
    
    
    
    
 