# -*- coding: utf-8 -*-

from vector import Vector
from gpanel import *


class Plotter:
    def __init__(self):
        self.d = 1930   # Abstand der Aufhängepunkte
        self.r = [1445, 1445]  # Radien im Nullpunkt
        self.m = [0,0]    # Motorenstellung
        self.proSchritt = 0.0157029  # Radiusänderung pro Schritt
        self.drawing = False  # Stift auf Board?
        
        # Fenstergrösse
        makeGPanel(Size(1024, 665))
        window(0,2000,1300,0)
        storeGraphics()
        self.r2x()
        self.drawBot()
        
        
    def clear(self):
        clearStore("white")
        self.draw()
        
    def r2x(self):
        self.x = (self.r[0]**2-self.r[1]**2+self.d**2)/self.d/2
        self.y = (self.r[0]**2-self.x**2)**0.5
        self.x += (2000-self.d)/2

    def motorsTo(self, m1,m2):
        move(self.x, self.y)
        self.r[0] += (m1-self.m[0])*self.proSchritt
        self.r[1] += (m2-self.m[1])*self.proSchritt
        self.m[0] = m1
        self.m[1] = m2
        self.r2x()
        recallGraphics()
        if self.drawing:
            lineTo(self.x, self.y)
            storeGraphics()
        self.drawBot()
        
    def realisticTo(self,m1, m2):
        startm1 = self.m[0]
        startm2 = self.m[1]
        dm1 = m1-self.m[0]
        dm2 = m2-self.m[1]
        m = max((abs(dm1),abs(dm2)))
        for i in range(0,m,20):
            self.motorsTo(int(startm1+i/m*dm1), int(startm2+i/m*dm2))
        self.motorsTo(m1,m2)
        
    def penDown(self):
        self.drawing = True
        
    def penUp(self):
        self.drawing = False  
    
    def drawBot(self):
        move(self.x, self.y)
        circle(30)
        line(self.x, self.y, (2000-self.d)/2,0)
        line(self.x, self.y, 2000-(2000-self.d)/2,0)
        
    def linie(self, a,b):
        line(a.x, a.y, b.x, b.y)

if __name__ == "__main__":
    plotter = Plotter()
    plotter.penDown()
    plotter.realisticTo(-10000,-10000)
    plotter.realisticTo(-20000,-2000)
    plotter.realisticTo(-20000,-20000)
    plotter.realisticTo(20000,-20000)
    plotter.realisticTo(0,0)
    
    













