# -*- coding: utf-8 -*-

from vector import Vector
from bezier import Bezier
from kurve import Kurve
from kurven import Kurven
from bbox import BBox


# SVG PATH COMMANDS:
# M = moveto
# L = lineto
# H = horizontal lineto
# V = vertical lineto
# C = curveto
# S = smooth curveto
# Q = quadratic Bézier curve
# T = smooth quadratic Bézier curveto
# A = elliptical Arc
# Z = closepath

class Parser:
    def __init__(self, svgDatei):
        self.svgDatei = svgDatei
        self.einlesen()
        self.parsen()
    
    def einlesen(self):
        with open(self.svgDatei, 'r') as content_file:
            content = content_file.read()
        # Anfangsposition vom path
        position = content.find("<path")
        if position<0:
            raise BaseException("Kein <path gefunden!")
        
        # d=" suchen... (ab der Position position)
        while True:
            position = content.find("d=\"", position)
            if position<0:
                BaseException("Kein d= gefunden")
                
            if content[position-1]<'0': # kein Buchstabe vor d
                break
            
            position+=1
        # Erste 20 Zeichen vom d
        
        start = position+3
        ende = content.find("\"", start)
        
        pfaddef = content[start:ende]
        # print(pfaddef)
        pfaddef = pfaddef.replace(",", " ")
        # print(pfaddef)
        self.elemente = pfaddef.split(" ")
        
        print(self.elemente)
        #self.elemente = ["m", "10", "10", "h", "5", "l", "0", "5", "l", "-5", "-5","z"]
        #for e in self.elemente:
        #    print(e)
        
    # 
    def punkteLesen(self, num, relative):
        # Achtung: Das kann schiefgehen, es kann nämlich ein z anstelle von Koordinaten stehen:
        # https://www.w3.org/TR/svg-paths/#PathDataClosePathCommand
        pts = [Vector((float(self.elemente[self.elpos+i*2]), \
                       float(self.elemente[self.elpos+i*2+1])))  for i in range(num)]
        #for p in pts:
        #    print(p)
        if relative:
            for i in range(num):
                pts[i] += self.pakt
        self.elpos += 2*num
        return pts

    def parsen(self):
        # Aktuelle Koordinaten
        self.pakt = Vector((0.0, 0.0))
        # Position im elemente Array
        self.elpos = 0
        # letztes Kommando
        self.lastCMD = ""
        # Keine Kurven am Anfang
        self.kurven = Kurven()
        self.firstCurvePoint = self.pakt.copy()
        while self.elpos < len(self.elemente):
            aktCMD = self.elemente[self.elpos][0]
            #print(aktCMD)
            #print(self.pakt)
            if (aktCMD.isalpha()):
                # Element konsumieren
                self.elpos+=1
            else:
                # Letztes Kommando
                aktCMD = self.lastCMD
            # Relatives Kommando?
            relative = aktCMD.islower()
            # Kleinbuchstabe
            lowCMD = aktCMD.lower()
            # Letztes Kommand merken
            self.lastCMD = aktCMD
            
            # V, H Kommandos
            if lowCMD=="v" or lowCMD=="h":
                vh = float(self.elemente[self.elpos])
                # Element konsumieren
                self.elpos+=1
                if lowCMD=="v":
                    if relative:
                        to = Vector((0.0, vh)) + self.pakt
                    else:
                        to = Vector((self.pakt.x, vh))
                if lowCMD=="h":
                    if relative:
                        to = Vector((vh, 0.0)) + self.pakt
                    else:
                        to = Vector((vh, self.pakt.y))
                self.kurven.addBezier(Bezier((self.pakt, to)))
                self.pakt = to
                
            elif lowCMD=="m":  # Move
                pts = self.punkteLesen(1, relative)
                self.kurven.addKurve()
                self.pakt = pts[0]
                # Wenn danach Koordinaten folgen, ist das automatisch L oder l, siehe https://www.w3.org/TR/svg-paths/#PathDataMovetoCommands
                self.lastCMD = 'l' if relative else 'L'
                
            elif lowCMD=="z":  # Close
                firstPt = self.kurven.firstPt()
                #print(firstPt)
                self.kurven.addBezier(Bezier([self.pakt, firstPt]))
                self.pakt = firstPt.copy()
                
            else:  # 
                numPts = {"l":1, "q":2, "t":1, "c":3, "s":2}
                pts = self.punkteLesen(numPts[lowCMD], relative)
                # Kontrollpunkte spiegeln?
                if lowCMD=="t" or lowCMD=="s":
                    ctr = kurven.lastCTR()  # letzter Kontrollpunkt
                    ctr = self.pakt+(self.pakt-ctr)  # neuer Kontrollpunkt
                    pts = [ctr] + pts  # punkt vorne hinzufügen
                    
                pts = [self.pakt] + pts  # Startpunkt hinzufügen.
                    
                self.kurven.addBezier(Bezier(pts))
                self.pakt = pts[-1]
               
if __name__ == "__main__":
    
    parser = Parser("hello.svg")
    print(parser.kurven)
    bbox = parser.kurven.getBBox()
    print(bbox)