# -*- coding: utf8 -*-

from kurve import Kurve

# Sammlung von einzelen Kurve-Objekten,
# dazwischen wird der Stift angehoben.
class Kurven:
    def __init__(self):
        self.kurven = []
    
    def getBBox(self):
        res = None
        for k in self.kurven:    
            if res==None:
                res = k.getBBox()
            else:
                res = res + k.getBBox()
        return res

    # Letzter Kontrollpunkt ist
    # der vorletzte Punkt der letzten Bezierkurve der letzten Kurve        
    def lastCTR(self):
        return self.kurven[-1].lastCTR()
    
    # Neue Kurve beginnen (vorausgesetzt, die letzte, falls es diese gibt, hat schon was drin)
    def addKurve(self):
        if len(self.kurven)==0 or len(self.kurven[-1].beziers)>0:
            self.append(Kurve())  # Neue Kurve hinzufügen
            
    def append(self, kurve):
        self.kurven.append(kurve)
    
    # Neue Bezierkurve der letzten Kurve anhängen
    def addBezier(self, bezier):
        return self.kurven[-1].append(bezier)
        
    # Erster Punkt der ersten Bezierkurve der letzten Kurve        
    def firstPt(self):
        return self.kurven[-1].beziers[0].pts[0] 
    
    # Transformiert alle Kurven damit
    def transform(self, t):
        for k in self.kurven:
            k.transform(t)
        return self
    
    def copy(self):
        res = Kurven()
        for k in self.kurven:
            res.kurven.append(k.copy())
        return res        

    
    def __str__(self):
        res = "%d Kurven:\n" % len(self.kurven)
        for k in self.kurven:
            res += "%d Bezierkurven:\n" % len(k.beziers)
            res += str(k)
        return res