# -*- coding: utf8 -*-

from bezier import Bezier
                        
# Folge von zusammenhängenden
# Bezierkurven (ohne Stift heben)
class Kurve:
    def __init__(self):
        self.beziers = []
    
    def getBBox(self):
        res = None
        for b in self.beziers:
            if res==None:
                res = b.getBBox()
            else:
                res = res + b.getBBox()
        return res

    # Neue Bezierkurve anhängen    
    def append(self,bezier):
        self.beziers.append(bezier)
    
    
    def lastCTR(self):
        # Vorletzter Punkt der letzten Bezierkurve
        return self.beziers[-1].lastCTR()
    
    # Transformiert alle Bezierkurven damit
    def transform(self, t):
        for b in self.beziers:
            b.transform(t)
        return self
    
    def copy(self):
        res = Kurve()
        for b in self.beziers:
            res.append(b.copy())
        return res        

    # Liefert eine Folge von Punkten auf der Kurve, 
    # die höchstens maxdist voneinander entfernt sind.
    # Der letzte Punkt ist wahlweise dabei oder nicht,
    # Das interval für t kann gewählt werden.
    def ptList(self, maxdist, mitLetztem=True):
        res = []
        for b in self.beziers:
            res += b.ptList(maxdist, False)
        if mitLetztem and len(self.beziers)>0: # Letzten Punkt hinzufügen, wenn es denn einen gibt.
            res += [self.beziers[-1].pts[-1]]
        return res
    
    def __str__(self):
        res = ""
        for b in self.beziers:
            res+=str(b)
            res+=" -\\\n"
        return res