from gpanel import *
from vector import Vector
from bezier import Bezier
from math import sin,cos
import time

makeGPanel(Size(800,800))  # Fenster oeffnen
window(0, 800, 0, 800)     # Koordinatensystem


# from https://stackoverflow.com/questions/24852345/hsv-to-rgb-color-conversion
# Input: Dezimalzahlen zwischen 0.0 und 1.0
# Output: Dezimalzahlen zwischen 0.0 und 1.0
def hsv_to_rgb(h, s, v):
        if s == 0.0: return (v, v, v)
        i = int(h*6.) # XXX assume int() truncates!
        f = (h*6.)-i; p,q,t = v*(1.-s), v*(1.-s*f), v*(1.-s*(1.-f)); i%=6
        if i == 0: return (v, t, p)
        if i == 1: return (q, v, p)
        if i == 2: return (p, v, t)
        if i == 3: return (p, q, v)
        if i == 4: return (t, p, v)
        if i == 5: return (v, p, q)

def farbe(t, v):
    h = (v.comp[2]/200-t/5) % 1.0;   # Farbton aus Zeit und z-Koordinate berechnen
    r,g,b = hsv_to_rgb(h, 1.0, 1.0)
    setColor(r*255,g*255,b*255)    

from posdata import leds
leds = [Vector(led) for led in leds]
enableRepaint(False)    # Nicht automatisch zeichnen
start = time.time();
print(start)
for i in range(1000):
#    auge = Vector([30*cos(i/13),300,100+50*sin(i/5)])
    auge = Vector([0,300,100+50*sin(i/20)])
    setColor("black")
    fillRectangle(0,0,800,800)
    setColor("white")
    for led in leds:
        p = led.rotatexy(i/30).projectxz(auge)
        p *= 3
        p += Vector([400,50])
        t = time.time()-start
        farbe(t, led)
        p.circle()
    repaint()  # Erst jetzt Grafik aktualisieren.
    time.sleep(0.04)