#!/usr/bin/env python
# -*- coding: utf-8 -*-

class Bezier:
    def __init__(self, pts):
        self.pts = [p for p in pts]  # Array kopieren
        
    # Punkt auf Kurve für Parameter t
    def x(self,t):
        return (1-t)**3*self.pts[0] + \
                3*(1-t)**2*t*self.pts[1] + \
                3*(1-t)*t**2*self.pts[2] + \
                t**3*self.pts[3]
        
        
    def combine(self, t):
        pts = self.pts
        while len(pts)>1:
            # Alternative: pts = [(1-t)*pts[i] + t*pts[i+1] for i in range(0, len(pts)-1)]
            neu =[]
            for i in range(0, len(pts)-1):
                neu.append((1-t)*pts[i] + t*pts[i+1])
                neu[-1].dot()
            pts = neu
        return pts[0]  # Resultat als erstes (und einziges) Element der Liste
