#!/usr/bin/env python
# -*- coding: utf-8 -*-

from gpanel import *
from vector import Vector
from bezier import Bezier
from math import sin,cos
import time

makeGPanel(Size(500,500))  # Fenster oeffnen
window(0, 500, 0, 500)     # Koordinatensystem

# Sich selbst schneidende Bezierkurve
pts = [Vector([0,0]), Vector([1000,800]), Vector([-400,400]), Vector([500,0])]


# Herz:
#draw((0.5,0.7)..controls (0.5,1.1) and (1, 1.1)..(1,0.7));
#draw((1,0.7)..controls (1, 0.3) and (0.5,0.2)..(0.5,0));

pts = [Vector([0.5,0.7]), Vector([0.5,1.1]), Vector([1, 1.1]), Vector([1,0.7]),\
       Vector([1,0.7]), Vector([1, 0.3]), Vector([0.5,0.2]), Vector([0.5,0])]


pts += [Vector([1-v.comp[0], v.comp[1]]) for v in pts]

pts = [v*300+Vector([100,100]) for v in pts]

kurven = [Bezier(pts[i:(i+4)]) for i in range(0,16,4)]


# Anständige Bezier-Kurve
#pts = [Vector([200,0]), Vector([-200,800]), Vector([800,400]), Vector([300,0])]

# bezier = Bezier(pts);

#bezier.distAnalytisch(Vector([200,200]))
#exit()

# from https://stackoverflow.com/questions/24852345/hsv-to-rgb-color-conversion
# Input: Dezimalzahlen zwischen 0.0 und 1.0
# Output: Dezimalzahlen zwischen 0.0 und 1.0
def hsv_to_rgb(h, s, v):
        if s == 0.0: return (v, v, v)
        i = int(h*6.) # XXX assume int() truncates!
        f = (h*6.)-i; p,q,t = v*(1.-s), v*(1.-s*f), v*(1.-s*(1.-f)); i%=6
        if i == 0: return (v, t, p)
        if i == 1: return (q, v, p)
        if i == 2: return (p, v, t)
        if i == 3: return (p, q, v)
        if i == 4: return (t, p, v)
        if i == 5: return (v, p, q)


    
start = time.time()
enableRepaint(False)

for y in range(500):
    for x in range(500):
        d = min([k.distAnalytisch(Vector([x,y]))[1] for k in kurven])
        
        r,g,b = hsv_to_rgb((d/100)%1.0, 1.0, 1.0)
        setColor(int(r*255), int(g*255), int(b*255))
        point(x,y)       
    zeit = time.time()-start
    rem = zeit/(y+1)*(499-y);
    tot = zeit+rem;
    repaint()
    print("Elapsed %02d:%02d, Remaining %02d:%02d, Total %02d:%02d" % (int(zeit/60), int(zeit%60), int(rem/60), int(rem%60), int(tot/60), int(tot%60)))

setColor(0,0,0)
n=32
for bezier in kurven:
    for i in range(n+1):
        bezier.x(i/n).circle()
repaint()
