#!/usr/bin/env python
# -*- coding: utf-8 -*-

# F ist eine Liste von Koeffizienten eines Polynomes
# mit aufsteigenden Exponenten
def ableitung(f):
    return [i*f[i] for i in range(1,len(f))]

# Polynom an der Stelle t auswerten
def auswerten(f,t):
    w = 0.0
    for i in range(len(f)-1, -1, -1):
        w *= t;
        w += f[i]
    return w

def newton(f, f1, t):
    for i in range(5):
        t = t - auswerten(f,t)/auswerten(f1,t)
        #print("%.20f" % t)
    #print("  -> f(t) = %.20f" % auswerten(f,t))
    return t

class Bezier:
    def __init__(self, pts):
        self.pts = [p for p in pts]  # Array kopieren
        
    # Punkt auf Kurve für Parameter t
    def x(self,t):
        return (1-t)**3*self.pts[0] + \
                3*(1-t)**2*t*self.pts[1] + \
                3*(1-t)*t**2*self.pts[2] + \
                t**3*self.pts[3]
        
    def distWrong(self, p):
        return 0, (p-self.pts[0]).norm()
    

    def distBruteForce(self, p, n=200):
        bestt = 0.0
        bestd = (p-self.pts[0]).norm()
        for i in range(1, n+1):
            t = i/n
            d = (p-self.x(t)).norm()
            if (d<bestd):
                bestd = d
                bestt = t
        return bestt, bestd
    
    
    def distAnalytisch(self, p):
        x = p.comp[0]
        y = p.comp[1]
        ax = self.pts[0].comp[0]
        bx = self.pts[1].comp[0]
        cx = self.pts[2].comp[0]
        dx = self.pts[3].comp[0]
        ay = self.pts[0].comp[1]
        by = self.pts[1].comp[1]
        cy = self.pts[2].comp[1]
        dy = self.pts[3].comp[1]
        # Koeffizienten vom Polynom f(t) 6-ten Grades
        f=[y**2-2*ay*y+x**2-2*ax*x+ay**2+ax**2,\
            -6*(by*y-ay*y+bx*x-ax*x-ay*by-ax*bx+ay**2+ax**2),\
            -3*(2*cy*y-4*by*y+2*ay*y+2*cx*x-4*bx*x+2*ax*x-2*ay*cy-2*ax*cx-3*by**2+10*ay*by-3*bx**2+10*ax*bx-5*ay**2-5*ax**2),\
            -2*(dy*y-3*cy*y+3*by*y-ay*y+dx*x-3*cx*x+3*bx*x-ax*x-ay*dy-ax*dx-9*by*cy+12*ay*cy-9*bx*cx+12*ax*cx+18*by**2-30*ay*by+18*bx**2-30*ax*bx+10*ay**2+10*ax**2),\
            3*(2*by*dy-2*ay*dy+2*bx*dx-2*ax*dx+3*cy**2-18*by*cy+12*ay*cy+3*cx**2-18*bx*cx+12*ax*cx+18*by**2-20*ay*by+18*bx**2-20*ax*bx+5*ay**2+5*ax**2),\
            6*(cy*dy-2*by*dy+ay*dy+cx*dx-2*bx*dx+ax*dx-3*cy**2+9*by*cy-4*ay*cy-3*cx**2+9*bx*cx-4*ax*cx-6*by**2+5*ay*by-6*bx**2+5*ax*bx-ay**2-ax**2),\
            dy**2-6*cy*dy+6*by*dy-2*ay*dy+dx**2-6*cx*dx+6*bx*dx-2*ax*dx+9*cy**2-18*by*cy+6*ay*cy+9*cx**2-18*bx*cx+6*ax*cx+9*by**2-6*ay*by+9*bx**2-6*ax*bx+ay**2+ax**2]
        #print(f)
        f1 = ableitung(f)
        f2 = ableitung(f1)
        #print(f1)
        #print(f2)
        #Vorzeichenwechsel finden        
        n = 50
        w = f1[0] # auswerten(f1,0)
        kandidaten = [1.0]
        for i in range(1,n+1):
            ww = auswerten(f1,i/n)
            if (w*ww<0):  # unterschiedliche Vorzeichen?
                kandidaten.append(newton(f1,f2,(i-0.5)/n))
            
            w = ww
        
        bestt = 0
        bestf = f[0]
        for t in kandidaten:
            ft = auswerten(f,t)
            if ft<bestf:
                bestf = ft
                bestt = t
        
        return bestt, bestf**0.5;  # Funktion liefert Abstand im Quadrat
            

if __name__ == "__main__":
    poly = "f=[y^2-2*ay*y+x^2-2*ax*x+ay^2+ax^2,-6*(by*y-ay*y+bx*x-ax*x-ay*by-ax*bx+ay^2+ax^2),-3*(2*cy*y-4*by*y+2*ay*y+2*cx*x-4*bx*x+2*ax*x-2*ay*cy-2*ax*cx-3*by^2+10*ay*by-3*bx^2+10*ax*bx-5*ay^2-5*ax^2),-2*(dy*y-3*cy*y+3*by*y-ay*y+dx*x-3*cx*x+3*bx*x-ax*x-ay*dy-ax*dx-9*by*cy+12*ay*cy-9*bx*cx+12*ax*cx+18*by^2-30*ay*by+18*bx^2-30*ax*bx+10*ay^2+10*ax^2),3*(2*by*dy-2*ay*dy+2*bx*dx-2*ax*dx+3*cy^2-18*by*cy+12*ay*cy+3*cx^2-18*bx*cx+12*ax*cx+18*by^2-20*ay*by+18*bx^2-20*ax*bx+5*ay^2+5*ax^2),6*(cy*dy-2*by*dy+ay*dy+cx*dx-2*bx*dx+ax*dx-3*cy^2+9*by*cy-4*ay*cy-3*cx^2+9*bx*cx-4*ax*cx-6*by^2+5*ay*by-6*bx^2+5*ax*bx-ay^2-ax^2),dy^2-6*cy*dy+6*by*dy-2*ay*dy+dx^2-6*cx*dx+6*bx*dx-2*ax*dx+9*cy^2-18*by*cy+6*ay*cy+9*cx^2-18*bx*cx+6*ax*cx+9*by^2-6*ay*by+9*bx^2-6*ax*bx+ay^2+ax^2]"
  
    poly = poly.replace("^", "**")
    poly = poly.replace(",", ",\\\n")
    print(poly)
    
              
            