
def kennzahlen(alles, namen):
    k = {}
    for name in namen:
        auswertung = __import__(name)
        for buchstabe,personen in alles.items():
            if not buchstabe in k:
                k[buchstabe] = {}
            for person, zeichnungen in personen.items():
                if not person in k[buchstabe]:
                    k[buchstabe][person] = [{} for z in zeichnungen]
                for i,zeichnung in enumerate(zeichnungen):
                    resultat = getattr(auswertung, name)(zeichnung) 
                    if type(resultat) is list:
                        for ri,r in enumerate(resultat):
                            k[buchstabe][person][i]["%s%02d" % (name,ri)] = r
                    else:
                        k[buchstabe][person][i][name] = resultat 
    return k


if __name__=="__main__":
    from einlesen import einlesen
    alles = einlesen()
    k = kennzahlen(alles, ["anzahlstriche", "strichdauer"])
    print(k['A'])


