/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package snake.server;

/**
 *
 * @author ivo
 */
public class Game {
    public final int n;
    public final Field field;
    public final Connection[] connections;
    public final String name;
    public final boolean pub;
    private int connected=0;
    
    public Game(int n, String name, Field field, boolean pub) {
        this.n = n;
        this.pub = pub;
        this.name = name;
        this.field = field;
        connections = new Connection[n];
    }
    
    public String show() {
        return String.format("%d %d %d %d %s",n,n-connected, field.width,field.height, name);
    }
    
    public boolean join(Connection c) {
        if (connected<n) {
            connections[connected++]=c;
            return connected==n;
        }
        return false;
    }
    
    public boolean available() {
        return connected<n;
    }
}
