/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package snake.server;

import java.util.ArrayList;
import java.util.Arrays;

/**
 *
 * @author ivo
 */
public class Field {
    public final int width, height;
    private final char[][] data;
    private final int[][] age;
    private ArrayList<String> differences = new ArrayList<>();

    public Field(int w, int h) {
        data = new char[w][h];
        age = new int[w][h];
        width = w;
        height = h;
        for (int x=0; x<w; x++) {
            Arrays.fill(data[x],'.');
            data[x][0] = '#';
            data[x][height-1] = '#';
        }
        for(int y=0; y<h; y++) {            
            data[0][y] = '#';
            data[width-1][y] = '#';
        }
    }
    
    public Field(int w, int h, String[] lines) {
        this(w,h);
        for(int y=0; y<h; y++) {
            for (int x=0; x<w; x++) {
                data[x][y] = lines[y].charAt(x);
            }
        }
    }
    
    public Field(int w, int h, Connection c) {
        this(w,h);
        for(int y=0; y<h; y++) {
            String line = c.nextLine();
            if (line!=null) {
                for (int x=0; x<w; x++) {
                    data[x][y] = line.charAt(x);
                }
            }
        }
    }
    
    public void set(int x, int y, char c, int age) {
        if (data[x][y]!=c) {
            data[x][y] = c;
            this.age[x][y] = age;
            differences.add(String.format("%d %d %c", x,y,c));
        }
    }
    public void set(int[] p, char c, int age) {
        set(p[0], p[1], c, age);
    }
    
    public void setAge(int x, int y, int age) {
        this.age[x][y] = age;
    }
    public void setAge(int[] p, int age) {
        setAge(p[0], p[1], age);
    }
    
    public void doAgeStep() {
        for(int y=0; y<height; y++) {
            for (int x=0; x<width; x++) {
                if (age[x][y]>0) {
                    age[x][y]--;
                    if (age[x][y]==0) {
                        set(x,y,'.',0);
                    }
                }
            }
        }
    }
    
    public char get(int x, int y) {
        return data[x][y];
    }
    
    public char get(int[] p) {
        return get(p[0],p[1]);
    }
    
    public void clearHistory() {
        differences.clear();
    }
    
    public void writeHistory(Connection c, int remapPlayer) {
        char r = (char) ('0'+remapPlayer);
        c.println(""+differences.size());
        differences.forEach(l -> c.println(l.replace('0', 'P').replace(r,'0').replace('P', r)));
    }
    
    public void writeField(Connection c, int remapPlayer) {
        char r = (char) ('0'+remapPlayer);
        for (int y=0; y<height; y++) {
            for (int x=0; x<width; x++) {
                switch (data[x][y]) {
                    case '0':
                        c.print(r);
                        break;
                    case 'r':
                        c.print('0');
                        break;
                    default:
                        c.print(data[x][y]);
                        break;
                }
            }
            c.print('\n');
        }
    }
    
    public String checkField(int players) {
        // Check size
        if (width<10 || height<10) {
            return "Feld zu klein! Min 10x10!";
        }
        // Check boundary
        for (int x=0; x<width; x++) {
            if (data[x][0] != '#' || data[x][height-1] != '#') {
                return "Feld nicht mit Mauern umrahmt!";
            }
        }
        for(int y=0; y<height; y++) {            
            if (data[0][y] != '#' || data[width-1][y] != '#') {
                return "Feld nicht mit Mauern umrahmt!";
            }
        }
        // Check starting positions
        for (int p=0; p<players; p++) {
            if (countChar((char)('0'+p))!=1) {
                return "Keine oder zu viele Startpositionen für Spieler "+p;
            }
        }
        return null;
    }
    
    private int countChar(char c) {
        int count = 0;
        for (int x=0; x<width; x++) {
            for (int y=0; y<height; y++) {
                if (data[x][y]==c) {
                    count++;
                }
            }
        }
        return count;
    }
    
    public int[] getPosition(int p) {
        char r = (char)('0'+p);
        for (int x=1; x<width-1; x++) {
            for (int y=1; y<height-1; y++) {
                if (data[x][y]==r) {
                    return new int[]{x,y};
                }
            }
        }
        return null;
    }
    
}
