/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package snake.server;

import java.io.IOException;
import java.io.PrintStream;
import java.net.Socket;
import java.util.NoSuchElementException;
import java.util.Scanner;
import java.util.logging.Level;
import java.util.logging.Logger;

/**
 *
 * @author ivo
 */
public class Connection {
    private final Scanner in;
    private final PrintStream out;
    private final Socket socket;
    public boolean debug=true;
    private int id = 0;
    private static int counter=0;
    private static final Object MUTEX = new Object();
    
    public Connection(Socket socket) throws IOException {
        this.socket = socket;
        in = new Scanner(socket.getInputStream());
        out = new PrintStream(socket.getOutputStream());
        synchronized(MUTEX) {
            id=Connection.counter++;
        }
    }
    
    public boolean alive() {
        return !socket.isClosed();
    }
    
    public String nextLine() {
        if (alive()) {
            try {
                String res = in.nextLine();
                if (res.charAt(res.length()-1)=='\r') {
                    System.out.format("[%d]< %s\n", id, res);
                    res = res.substring(0,res.length()-1);
                }
                if (debug) {
                    System.out.format("[%d]< %s\n", id, res);
                }
                return res;
            } catch (IllegalStateException|NoSuchElementException ex) {
                sendError(ex.getMessage());
            }
        }
        return null;
    }
    
    public int nextInt() {
        if (alive()) {
            try {
                int res = in.nextInt();
                if (debug) {
                    System.out.format("[%d]< %d\n", id, res);
                }
                return res;
            } catch (IllegalStateException|NoSuchElementException ex) {
                sendError(ex.getMessage());
            }
        }
        return -1;
    }
   
    public boolean println(String s) {
        if (alive()) {
            out.println(s);
                if (debug) {
                    System.out.format("[%d]> %s\n", id,  s);
                }
            return alive();
        } else {
            return false;
        }
    }
    
    public boolean print(char c) {
        if (alive()) {
            out.print(c);
                if (debug) {
                    System.out.format("%c", c);
                }
            return alive();
        } else {
            return false;
        }
    }
    
    
    void sendError(String msg) {
        if (alive()) {
            try {
                out.println("ERROR");
                out.println(msg);
                System.out.format("[%d]> ERROR\n> %s\n", id, msg);
                close();
            } catch (Exception e) {
                
            }
        }
    }

    public boolean flush() {
        try {
            out.flush();
            return alive();
        } catch (Exception e) {
            
        }
        return false;
    }
    
    public void close() {
        out.close();
        in.close();
        try {
            socket.close();
        } catch (IOException ex) {
            Logger.getLogger(Connection.class.getName()).log(Level.SEVERE, null, ex);
        }
    }
    
}
