/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package snake.fields;

import java.util.Arrays;

/**
 *
 * @author ivo
 */
public class Field {
    final char[][] data;
    final int w,h,n;
    
    Field(int w, int h, int n) {
        this.w = w;
        this.h = h;
        this.n = n;
        data = new char[h][w];
    }
    
    public static Field create(int w, int h, int n) {
        Field f = new Field(w,h,n);
        Field.fillData(f);
        Field.placePlayers(f);
        return f;
    }
    
    static void fillData(Field f) {
        for (int y=0; y<f.h; y++) {
            Arrays.fill(f.data[y],'.');
            f.data[y][0] = '#';
            f.data[y][f.w-1] = '#';
        }
        for (int x=0; x<f.w; x++) {
            f.data[0][x] = '#';
            f.data[f.h-1][x] = '#';
        }
    }
    static void placePlayers(Field f) {
        int[][] vec = {{1,0}, {0,-1}, {1,0}, {0,-1}, {1,1}, {-1,-1}, {1,-1},{-1,1},{0,0}};
        if (f.n>vec.length) {
            throw new RuntimeException("Too many players for this field!");
        }
        for (int i=0; i<f.n; i++) {
            f.data[f.h/2+f.h/3*vec[i][1]][f.w/2+f.w/3*vec[i][0]] = (char)('0'+i);
        }
    }
    
    public void addLabyWalls() {
        for (int y=0; y<h*3/4; y++) {
            data[y][w/3] = '#';
            data[h-y-1][2*w/3] = '#';
        }
    }

    public void addThreeRooms() {
        for (int y=0; y<h; y++) {
            if (Math.abs(y-h/2)>1) {
                data[y][w/3] = '#';
                data[y][2*w/3] = '#';
            }
        }
    }
    
    public void addNineRooms() {
        for (int y=0; y<h; y++) {
            if (Math.abs(y-h/3)>1 && Math.abs(y-h*2/3)>1) {
                data[y][w/3] = '#';
                data[h-y-1][2*w/3] = '#';
            }
        }
        for (int x=0; x<w; x++) {
            if (Math.abs(x-w/3)>1 && Math.abs(x-w*2/3)>1) {
                data[h/3][x] = '#';
                data[h*2/3][x] = '#';
            }
        }
        
    }
    
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(String.format("%d %d %d\n",n,w,h));
        for (int y=0; y<h; y++) {
            sb.append(data[y]);
            sb.append('\n');
        }
        return sb.toString();                
    }
    
    public String[] getLines() {
        String[] res = new String[h];
        for (int y=0; y<h; y++) {
            res[y] = new String(data[y]);
        }
        return res;
    }
}
