/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package snake.communicator;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.net.Socket;
import java.util.Scanner;
import java.util.logging.Level;
import java.util.logging.Logger;

/**
 *
 * @author ivo
 */
public class NetClientCommunicator implements Communicator {

    private Scanner in;
    private PrintStream out;
    private Socket socket;
    
    public NetClientCommunicator(String server, int port) {
        try {
            socket = new Socket(server, port);
            in = new Scanner(socket.getInputStream());
            out = new PrintStream(socket.getOutputStream());
        } catch (IOException ex) {
            Logger.getLogger(NetClientCommunicator.class.getName()).log(Level.SEVERE, null, ex);
            System.exit(1);
        }
    }

    @Override
    public Scanner in() {
        return in;
    }

    @Override
    public PrintStream out() {
        return out;
    }

    @Override
    public void close() {
        try {
            in.close();
            out.close();
            socket.close();
        } catch (IOException ex) {
            Logger.getLogger(NetClientCommunicator.class.getName()).log(Level.SEVERE, null, ex);
        }
    }
    
}
