/*
 * Library to use different Roborobo components with an Arduino.
 * 
 * Copyleft by Ivo Bloechliger (ivo.bloechliger@ksbg.ch).
 * 
 * This code is licenced under the 
 * GNU GENERAL PUBLIC LICENSE, Version 3, 29 June 2007
 * 
 * Please refer to https://www.gnu.org/licenses/gpl.html 
 * for the full text license.
 * 
 * 
 * 
 * Please note that this is my first Arduino Library, so excpect 
 * things to break. You can only blame yourself...
 */


#ifndef Roborobo_h                                                                                                                                                                                                 
#define Roborobo_h

class RemoteControl {
  public:
    RemoteControl(int pin);
    int poll();      // must be called inside loop(), at least once every ms
                     // returns 0 if nothing new has happened, 1 otherwise
    int getState();   // current state, bitmask
    int lastState();  // last state, bitmask
    long getAge();     // age of last state
  private:
    int _pin;
    int _state;  // Button mask
    long _age;    // time of last state update
    int _signal; // Which part we're currently excpecting
    int _lowhigh;
    long _last;   // last millis() since change
    int _d1, _d2; // read digits.
    static volatile RemoteControl* rc;
    static void isr();
};




#endif
