/*
 * Library to use different Roborobo components with an Arduino.
 * 
 * Copyleft by Ivo Bloechliger (ivo.bloechliger@ksbg.ch).
 * 
 * This code is licenced under the 
 * GNU GENERAL PUBLIC LICENSE, Version 3, 29 June 2007
 * 
 * Please refer to https://www.gnu.org/licenses/gpl.html 
 * for the full text license.
 * 
 * 
 * 
 * Please note that this is my first Arduino Library, so excpect 
 * things to break. You can only blame yourself...
 */

#include "Arduino.h"
#include "roborobo.h"

volatile RemoteControl* RemoteControl::rc;

RemoteControl::RemoteControl(int pin) {
  pinMode(pin,INPUT);
  _pin = pin;
  _age = -1;
  _state = 0;
  _signal = 0;
  _lowhigh = digitalRead(_pin);
  _last= 0;
  if (_pin==2 || _pin==3) {
    rc = this;
    attachInterrupt(digitalPinToInterrupt(_pin), isr, CHANGE);
  }
}

void RemoteControl::isr() {
  rc->_lowhigh = digitalRead(rc->_pin);
  long m = micros();
  long d = (m-rc->_last+500)/1000;
  rc->_last=m;
  if (rc->_lowhigh==0) {
      if (rc->_signal==0 && d==1) {
        rc->_signal=1;
      } else if (rc->_signal==1) {
        rc->_d1 = d-2;
        rc->_signal = 2;
      } else if(rc->_signal==2) {
        rc->_state = rc->_d1+((d-2)<<4);
        rc->_signal=0;
        rc->_age = millis();
      }
  }
}

int RemoteControl::poll() {
  if ((_pin==2 || _pin==3) && millis()-_age<10) return 1;
  if (micros()-_last>500 && digitalRead(_pin)!=_lowhigh) {
    long d = (micros()-_last+500)/1000;
    _last = micros();
    _lowhigh=1-_lowhigh;
    if (_lowhigh==0) {
      if (_signal==0 && d==1) {
        _signal=1;
      } else if (_signal==1) {
        _d1 = d-2;
        _signal = 2;
      } else if(_signal==2) {
        _state = _d1+((d-2)<<4);
        _signal=0;
        _age = millis();
        return 1;
      }
    }
  }
  return 0;
}

int RemoteControl::lastState() {
  return _state;
}

long RemoteControl::getAge() {
  return millis()-_age;
}

int RemoteControl::getState() {
  if (getAge()<20) return lastState();
  return 0;
}

