/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package animation;

import ch.ksbg.fginfo.Painter;
import java.awt.Color;
import java.util.ArrayList;

/**
 *
 * @author ivo.bloechliger
 */
public class Actor {
    private double x,y;
    private double vx,vy;
    private Color myColor = new Color((int)(Math.random() * 0x100_0000));
    
    private static ArrayList<Actor> actors = new ArrayList<>();
    
    public Actor() {
        x = 100;
        y = 100;
        vx = 2;
        vy = 1;
        Actor.actors.add(this);
    }
    
    public Actor(double x, double y, double vx, double vy) {
        this.x = x;
        this.y = y;
        this.vx = vx;
        this.vy = vy;
        Actor.actors.add(this);
    }
    
    public static void nextStepAll() {
        for (Actor a : actors) {
            a.nextStep();
        }
    }
    
    public static void drawAll() {
        for (Actor a : actors) {
            a.draw();
        }
    }
    
    public void nextStep() {
        vy+=0.02;
        x+=vx;
        y+=vy;
        if (x>Painter.getWidth()) {
            x=Painter.getWidth();
            vx=-vx;
        }
        if (y>Painter.getHeight()) {
            y=Painter.getHeight();
            vy=-vy;
        }
        if (x<0) {
            x=0;
            vx=-vx;
        }
        if (y<0) {
            y=0;
            vy=-vy;
        }

    }
    
    public void draw() {
        Painter.setColor(myColor);
        Painter.fillDisk((int)x, (int)y, 10);
    }
}
