import machine
import neopixel
import mcp





class Helper:
    
    # Ports, an dem die Joysticks haengen (X,Y,Switch)
    JOYSTICKS = [[34,35,25],[33,32,26]]
    # Adresse vom PortExpander
    MCP_ADDRESS = 0x27
    
    def __init__(self):
        self.np = neopixel.NeoPixel(machine.Pin(4), 150, timing=True)
        self.np.write();
        self.mcp = mcp.MCP(Helper.MCP_ADDRESS, self.np)
        self.joyPorts = [[machine.ADC(machine.Pin(Helper.JOYSTICKS[0][0])), 
                          machine.ADC(machine.Pin(Helper.JOYSTICKS[0][1])), 
                          machine.Pin(Helper.JOYSTICKS[0][2],machine.Pin.IN, machine.Pin.PULL_UP)],
                         [machine.ADC(machine.Pin(Helper.JOYSTICKS[1][0])), 
                          machine.ADC(machine.Pin(Helper.JOYSTICKS[1][1])), 
                          machine.Pin(Helper.JOYSTICKS[1][2],machine.Pin.IN, machine.Pin.PULL_UP)]]
        
        
    # Nullpunkt unten links, x nach rechts, y nach oben
    def pixelNumber(self, x,y):
        return (9-x)*15 + (y if x%2==1 else 14-y) # Diese Funktion muss angepasst werden, je nachdem, wie der LED-Streifen eingebaut ist
    
    
    def setPixel(self, x,y,c):
        if (x>=0 and x<=9 and y>=0 and y<=14):
            n = self.pixelNumber(x,y)
            self.np[n]=c   
        
    def invertPixel(self, x,y):
        if (x>=0 and x<=9 and y>=0 and y<=14):
            n = self.pixelNumber(x,y)
            c = self.np[n]
            self.np[n]=  (255-c[0], 255-c[1], 255-c[2])
        
    def getButtons(self):
        return self.mcp.getButtons()   # Diese Funtion muss eventuell angepasst werden, wenn die Buttons anders angeschlossen sind.
    
    def setLeds(self,l):
        self.mcp.setLeds(l)  # Diese Funktion muss enventuell angepasst werden, wenn die LEDs anders angeschlossen sind.
        
    def getLeds(self):
        return self.mcp.getLeds() # Dito
    
    def getJoyStick(self, n):
        return [self.joyPorts[n][0].read(), self.joyPorts[n][1].read(), self.joyPorts[n][1].value()]
    
        
    
        
