#import socketserver
import SocketServer
import datetime
from badblockchain import BadBlockChain, BadTransaction, BadBlock
import os.path
import logging


# GET /badcoin/getblocks[?nr] -> blocks from nr to current
# GET /badcoin/gettransactions
# PUT /badcoit/submittransaction -> OK / ERROR
# PUT /badcoin/submitblock -> OK / ERROR

logging.basicConfig(level=logging.DEBUG)
logger = logging.getLogger(__name__)


CHAINFILE="badblockchain.txt"
badBlockChain = None
transactions = []

class BadHandler(SocketServer.BaseRequestHandler):
    
    def responseOK(self, answer):
        r = "HTTP/1.1 200 OK\r\n"
        r += "Content-Type: text/plain; charset=UTF-8\r\n"
        r += "Server: BadCoinServer\r\n"
        r += "Content-Length: "+str(len(answer))+"\r\n"
        r += "Connection: close\r\n\r\n"
        r += answer
        logger.debug("Answer:")
        logger.debug(r)
        self.request.sendall(r)
        return
        
    def responseERROR(self, code, answer):
        r = "HTTP/1.1 "+str(code)+"\r\n"
        r += "Content-Type: text/plain; charset=UTF-8\r\n"
        r += "Server: BadCoinServer\r\n"
        r += "Content-Length: "+str(len(answer))+"\r\n"
        r += "Connection: close\r\n\r\n"
        r += answer
        logger.debug("Answer:")
        logger.debug(r)
        self.request.sendall(r)


    @classmethod
    def getResponse(cls, sock):
        response = sock.recv(4096).decode()
        lines = response.splitlines()
        logger.debug(lines)
        start = 0
        contentLength = 0
        while (lines[start]!=""):
            header = lines[start].split(":")
            if (header[0]=="Content-Length"):
                contentLength = int(header[1])
                logger.debug("ContentLength is "+str(contentLength))
            start+=1
        totalLength = contentLength+sum(map(lambda x:len(x)+2, lines[0:(start+1)]))
        logger.debug("Total length is "+str(totalLength)+", response is now "+str(len(response)))
        while len(response)<totalLength:
            response+=sock.recv(4096).decode()
            logger.debug("Total length is "+str(totalLength)+", response is now "+str(len(response)))
        lines = response.splitlines()
        return lines
        
    
    def handle(self):
        global badBlockChain, transactions
        timeout = datetime.datetime.now()+datetime.timedelta(milliseconds=50)
        lines = self.getResponse(self.request) #request.recv(4096).split("\n")
        logger.debug("Got:")
        logger.debug(lines)
        header = lines[0].split(" ")
        method = header[0]
        url = header[1][9:]
        logger.debug("  Method: "+method+"  URL: "+url)
        if method=="GET":
            tokens=url.split("?")
            if tokens[0]=="getblocks":
                nr=0
                if len(tokens)==2:
                    nr=int(tokens[1])
                answer = ""
                for i in xrange(nr,len(badBlockChain.blocks)):
                    answer+=str(badBlockChain.blocks[i])
                self.responseOK(answer)
                return
            if url=="gettransactions":
                answer = "\n".join(map(str, transactions))
                self.responseOK(answer)
                return
            self.responseERROR("404 Not found", "Sorry, this server only knows about 'getblocks[?nr]' and 'gettransactions'")
            return
        if method=="POST":
            logger.debug("POST")
            start = 0
            while (lines[start]!=""):
                start+=1
            start+=1
            if url=="transmittransaction":
                tr = BadTransaction(lines[start])
                if not (tr.valid):
                    self.responseERROR("400 Bad request", "Sorry, this transaction has no valid signature and is rejected.")
                    return
                badBlockChain.wallets.validate(tr)
                if not tr.valid:
                    self.responseERROR("400 Bad request", "Sorry, this transaction is not valid and is rejected.")
                    return
                if tr in transactions:
                    self.responseERROR("400 Bad request", "Sorry, this transaction is already queued.'")
                    return
                transactions.append(tr)
                self.responseOK("Your transaction has been queued.")
                return
            if url=="transmitblock":
                rawblock="\n".join(lines[start:])
                logger.debug("Got rawblock")
                logger.debug(rawblock)
                block = BadBlock(rawblock)
                if not block.valid:
                    self.responseERROR("400 Bad request", "Sorry, this block is not valid and is rejected: "+block.error)
                    return
                if not badBlockChain.validateBlock(block):
                    self.responseERROR("400 Bad request", "Sorry, this block contains invalid transactions and is rejected: "+badBlockChain.error)
                    return
                if not badBlockChain.processBlocks(rawblock):
                    self.responseERROR("500 WTF", "The blockchain is broken... This should not happen.'")
                    return
                for t in block.transactions:
                    if t in transactions:
                        transactions.remove(t)
                    
                with open(CHAINFILE, 'w') as myfile:
                    myfile.write(str(badBlockChain))
                    self.responseOK("Your block has been accepted.")
                    return
                
            self.responseERROR("404 Not found", "Sorry, this server only knows about 'transmittransaction' and 'transmitblock'")
            return
              

class BadServer():
    def __init__(self):
        global badBlockChain
        logger.debug("Init")
        if os.path.isfile(CHAINFILE):
            with open(CHAINFILE, 'r') as myfile:
                badBlockChain=BadBlockChain(myfile.read())
                if not badBlockChain.valid:
                    logger.debug("Block chain not valid!")
                    return
        else:
            badBlockChain = BadBlockChain()
        self.server = SocketServer.TCPServer(("localhost", 1337), BadHandler)
        try:
            self.server.serve_forever()
        except KeyboardInterrupt:
            self.server.server_close()
        finally:
            self.server.server_close()
        
        
    
BadServer()

