import random

class BadKeyMaterial:
    @classmethod
    def nextprime(cls, z):
        if (z<2):
            return 2
        if (z%2==0):
            return cls.nextprime(z+1)
        t = 3
        while (t*t<=z):
            if (z % t==0):
                return cls.nextprime(z+2)
            t+=1
        return z

    @classmethod
    def gcd(cls, a,b):
        if b==0:
            return a
        return cls.gcd(b, a % b)
    
    @classmethod
    def lcm(cls,a,b):
        return a*b//cls.gcd(a,b)
    
    # Pfff... same as  pow(a,b,m)
    @classmethod
    def modpow(cls,a,b,m):
        res = 1
        while (b>0):
            if (b%2==1):
                res= (res * a) % m
            a=(a*a)%m
            b=b//2;
        return res
    
    
    #From https://en.wikibooks.org/wiki/Algorithm_Implementation/Mathematics/Extended_Euclidean_algorithm
    # return (g, x, y) a*x + b*y = gcd(a, b)
    @classmethod
    def egcd(cls, a, b):
        if a == 0:
            return (b, 0, 1)
        else:
            g, x, y = cls.egcd(b % a, a)
            return (g, y - (b // a) * x, x)
        
    #From https://en.wikibooks.org/wiki/Algorithm_Implementation/Mathematics/Extended_Euclidean_algorithm
    # x = mulinv(b) mod n, (x * b) % n == 1
    @classmethod
    def mulinv(cls, b, n):
        g, x, _ = cls.egcd(b, n)
        if g == 1:
            return x % n

    # Number of bits, or public modulus
    def __init__(self,bits):
        if (bits>10000) :
            self.modulus=bits
            self.public=31
            self.private=0
        else:
            p = self.nextprime(random.randint(1<<(bits//2), 1<<(bits//2+1)))
            q = self.nextprime(random.randint(1<<(bits//2), 1<<(bits//2+1)))
            n = p*q
            l = self.lcm(p-1,q-1)
            e = 31
            d = self.mulinv(e,l)
            self.modulus = n
            self.public = e
            self.private = d

    def __str__(self):
        return "Public modulus: "+str(self.modulus)+" public exponent: "+str(self.public)+"  private exponent: "+str(self.private)

    # 32-Bit Hash
    @classmethod
    def badHash(cls,x):
        x = str(x)
        h = 0xdeadbeef
        for i in range(0,len(x)):
            h = ((h+6543)*(ord(x[i])+57361)+567) % 2**32
        return h
    
    def signature(self, what):
        return self.modpow(self.badHash(what),self.private, self.modulus)
    
    def verify(self, what, sign):
        return self.badHash(what)==self.modpow(sign,self.public, self.modulus)
    
    
if __name__ == "__main__":
    km = BadKeyMaterial(32)  # New 32-Bit Key (well 33 or 34)
    print(km)
    s = "This is my very personal message"
    sig = km.signature(s)
    print(s)
    print("Signature:",sig)
    print("Verification: ",km.verify(s,sig))
    print("Other message: ", km.verify("This is my very unpersonal message",sig))
    
    
