# Block:
# Blocknr\n
# previous hash\n
# number of transactions\n
# 0-n times: Timestamp, Wallet Origin, Wallet Target, Amount, Signature Origin\n
# where the signature is over the line up to and without the last comma (no use putting balances here, there wrong when submitting 2 transactions)
# Wallet Miner, Nonce\n

from badkeymaterial import BadKeyMaterial
import socket
import sys
import datetime
import random
from time import sleep
import logging

# logging.basicConfig()
FORMAT = "[%(filename)s:%(lineno)s - %(funcName)20s() ] %(message)s"
logging.basicConfig(format=FORMAT, level=logging.DEBUG)
logger = logging.getLogger(__name__)

HOST, PORT = "fginfo.ksbg.ch", 80


class BadTransaction:
    def __init__(self,rawline):
        logger.debug("new BadTransaction from ->"+rawline+"<-")
        items = rawline.split(",")
        self.timestamp = int(items[0])
        self.origin = int(items[1])
        self.target = int(items[2])
        self.amount = int(items[3])
#        self.balanceo = int(items[4])
 #       self.balancet = int(items[5])
        self.sig = int(items[4])
        transline = ",".join(items[0:-1])
        logger.debug("  transline "+transline)
        self.valid = BadKeyMaterial(self.origin).verify(transline,self.sig)
        if not self.valid:
            logger.warn("  Invalid transaction signature found.")
        
    def __str__(self):    
        return str(self.timestamp)+","+str(self.origin)+","+str(self.target)+","+str(self.amount)+","+str(self.sig)
    
    def __eq__(self, other):
        return self.timestamp == other.timestamp and self.origin==other.origin and self.target==other.target and self.sig==other.sig

class BadBlock:
    def __init__(self,rawblock):
        lines = rawblock.splitlines()
        self.nr = int(lines[0])
        self.lasthash = int(lines[1])
        self.numtrans = int(lines[2])
        self.valid=True
        self.error=""
        self.transactions = []
        self.lastline=""
        logger.debug("lines (len="+str(len(lines)))
        logger.debug(lines)
        if not (self.numtrans +4 == len(lines)):
            self.valid=False
            self.error = "Wrong number of lines"
            logger.warn(self.error)
            return 
        for i in range(0,self.numtrans):
            self.transactions.append(BadTransaction(lines[3+i]))
            if not self.transactions[-1].valid:
                self.valid=False
                self.error = "Error at transaction "+i
                logger.warn(self.error)
                return
                
        self.lastline = lines[3+self.numtrans]
        mining = self.lastline.split(",")
        self.miner = int(mining[0])
        self.nonce = int(mining[1])
        logger.debug("->"+rawblock+"<-")
        
        
        if not (self.blockhash() < BadBlockChain.difficulty()):
            self.valid=False
            self.error = "Hash of block > difficulty"
            logger.warn(self.error)
            return

    def blockhash(self):
        return BadKeyMaterial.badHash(str(self))

    def __str__(self):
        res = str(self.nr)+"\n"+str(self.lasthash)+"\n"+str(self.numtrans)+"\n"
        if (len(self.transactions)>0):
            res += "\n".join(map(str,self.transactions))+"\n"
        res += self.lastline+"\n"
        return res


class BadWallets:
    def __init__(self,badWallets=None):
        if badWallets==None:
            self.wallets={}
        else:
            self.wallets=badWallets.wallets.copy();

    def copy(self):
        return BadWallets(self)

    def validate(self,t):
        if not t.valid:
            return False
        if not t.origin in self.wallets:
            t.valid=False
            logger.warn("Origin wallet does not exist")
            return False
        if not t.target in self.wallets:
            self.wallets[t.target] = 0
        transfer = t.amount+BadBlockChain.transactionreward()
        if transfer<1:
            logger.warn("Must transfer at least 1 BadCoin")
            t.valid=False
            return False
        return True
        
    def processtransaction(self,t):
        if not self.validate(t):
            return False
        if self.wallets[t.origin] < t.amount+BadBlockChain.transactionreward():
            logger.warn("Insufficient funds!")
            return False
        self.wallets[t.target]+=t.amount
        self.wallets[t.origin]-=t.amount+BadBlockChain.transactionreward()
        return True
    
    def processMining(self,ntransactions, target):
        if not target in self.wallets:
            self.wallets[target]=0
        self.wallets[target] += BadBlockChain.transactionreward()*ntransactions + BadBlockChain.miningreward()
        return True

    def classifyTransactionsForBlock(self, transactions):
        backup = self.wallets.copy()
        ordered = sorted(transactions, key=lambda x: x.timestamp)
        ok = []
        rejected = []
        for t in ordered:
            if self.processtransaction(t):
                ok.append(t)
            else:
                rejected.append(t)
        self.wallets = backup
        return [ok, rejected]
                
    
    def processBlock(self,block):
        if not block.valid:
            logger.warn("Block not valid")
            return False
        for t in block.transactions:
            if not self.processtransaction(t):
                logger.warn("Failed to process transaction:")
                logger.warn(t)
                logger.warn(self.wallets)
                block.valid=False
                return False
        if not self.processMining(block.numtrans, block.miner):
            logger.warn("Failed to process Mining reward")
            block.valid=False
            return False
        return True
    

class BadBlockChain:
    @classmethod
    def difficulty(cls):
        return 1<<10  # 32-10=22 Bit Schwierigkeit (4 Mio Versuche bis Block gefunden)
    
    @classmethod
    def miningreward(cls):
        return 100
    
    @classmethod
    def transactionreward(cls):
        return 1
    
    @classmethod
    def maxtransactions(cls):
        return 100
    
    def __init__(self,rawchain=None, host=HOST, port=PORT):
        self.host = host
        self.port = port
        self.wallets = BadWallets()
        self.blocks=[]
        self.valid=True
        self.error=""
        if rawchain!=None:
            self.processBlocks(rawchain)

    def __str__(self):
        return "".join(map(str, self.blocks))
            
    def validateBlock(self, block):
        if not block.valid:
            logger.warn("Block not valid: ->"+block+"<-")
            return False
        if len(self.blocks)==0 and block.nr!=0:
            self.error = "First block must have number 0"
            logger.warn("First block must have number 0")
            return False
        if len(self.blocks)>0 and (block.nr!=self.blocks[-1].nr+1):
            self.error="Blocks must be numbered consecutively"
            logger.warn("Blocks must be numbered consecutively")
            return False
        w = self.wallets.copy();
        if not w.processBlock(block):
            logger.warn("Invalid transaction found")
            return False
        return True
        

    def processBlocks(self, rawchain):
        logger.debug("processBlocks")
        lines = rawchain.splitlines()
        n = len(lines)
        i = 0
        while (i<n):
            l = int(lines[i+2])+4
            self.blocks.append(BadBlock("\n".join(lines[i:(i+l)])+"\n"))
            if not self.blocks[-1].valid:
                self.valid=False
                self.error="Invalid block found, starting at line "+str(i)
                logger.warn(self.error)
                return False
            if not (self.wallets.processBlock(self.blocks[-1])):
                self.valid=False
                self.error="Error updating wallets in block starting at line "+str(i)
                logger.warn(self.error)
                return False
            i+=l
        return True
         
    def submitTransaction(self, amount, target, keymaterial):
        amount = int(amount)
        if (amount<1+BadBlockChain.transactionreward()):
            logger.warn("Too small an amount!")
            return False
        origin = keymaterial.modulus
        if keymaterial.private==0:
            logger.warn("No private key available")
            return False
        if not  origin in self.wallets.wallets:
            logger.warn("Unexistent wallet!")
            return False
        if (self.wallets.wallets[origin]<amount+BadBlockChain.transactionreward()):
            logger.warn("Not enough funds!")
            return False
        ts = int((datetime.datetime.now() - datetime.datetime(1970, 1,1)).total_seconds()*1000)
        tr = str(ts)+","+str(origin)+","+str(target)+","+str(amount)
        logger.debug("trans to sign: "+tr)
        sig = keymaterial.signature(tr)
        tr = tr+","+str(sig)
        logger.debug("trans with sign: "+tr)
        trans = BadTransaction(tr)
        if not trans.valid:
            logger.warn("Transaction is invalid for some reason...")
            return False
        
        sock = socket.socket(socket.AF_INET, socket.SOCK_STREAM)
        res = True
        try:
            # Connect to server and send data
            sock.connect((self.host, self.port))
            sock.sendall(("POST /badcoin/transmittransaction HTTP/1.1\r\nHost: whatever\r\nContent-Type: text/plain; charset=UTF-8\r\nContent-Length: "+str(len(tr))+"\r\nConnection: close\r\n\r\n"+tr).encode())
            response = sock.recv(4096).decode()
            lines = response.split("\n")
            if (lines[0]!="HTTP/1.1 200 OK\r"):
                logger.warn(response)
                res=False
        finally:
            sleep(0.1)
            sock.close()
        return res
        
    
    def mine(self, address):
        self.getNewBlocks()
        transactions=self.wallets.classifyTransactionsForBlock(self.getTransactions())[0] # only include "good" transactions
        logger.debug("Got "+str(len(transactions))+" valid transactions:")
        logger.debug(transactions)
        if not self.valid:
            return None
        if not all(t.valid for t in transactions):
            return None
        rawblock=""
        if len(self.blocks)>0:
            lastblock = self.blocks[-1]
            rawblock = str(lastblock.nr+1)+"\n"+str(lastblock.blockhash())+"\n"+str(len(transactions))+"\n"
        else: # First block
            rawblock = "0\n0\n"+str(len(transactions))+"\n"
        if len(transactions)>0:
            rawblock += "\n".join(map(str, transactions))+"\n"
        if not(address in self.wallets.wallets):
            self.wallets.wallets[address]=0
        rawblock += str(address)+","
        logger.debug("Rawblock")
        logger.debug(rawblock)
            
        
        nonce = random.randint(1<<20, 1<<21)
        d = 1
        n = nonce+d
        while (BadKeyMaterial.badHash(rawblock+str(nonce)+"\n")>=BadBlockChain.difficulty()):
            if (nonce>n):
                d*=2
                n=nonce+d
                logger.debug(nonce)
            nonce+=1
        rawblock += str(nonce)+"\n"
        logger.debug("-->"+rawblock+"<--")
        newblock = BadBlock(rawblock)
        if not newblock.valid:
            logger.warn(newblock.error)
            return False
        logger.debug(newblock)
        if not (newblock.valid):
            logger.warn("Block not valid")
            return False
        self.publish(newblock)
        
    def publish(self, newblock):
        sock = socket.socket(socket.AF_INET, socket.SOCK_STREAM)
        res=True
        try:
            # Connect to server and send data
            sock.connect((self.host, self.port))
            logger.debug("Submitting block")
            sock.sendall(("POST /badcoin/transmitblock HTTP/1.1\r\nHost: whatever\r\nContent-Type: text/plain; charset=UTF-8\r\nContent-Length: "+str(len(str(newblock)))+"\r\nConnection: close\r\n\r\n"+str(newblock)).encode())
            ok, lines = self.getResponse(sock)
            if not ok:
                logger.warn("Failed: "+str(lines))
            else:
                self.processBlocks(str(newblock))
                res = self.valid
        finally:
            
            sock.close()
        return res
       
            
                        
    def getNewBlocks(self):
        nr = ""
        if (len(self.blocks)>0):
            nr = "?"+str(self.blocks[-1].nr+1)
        sock = socket.socket(socket.AF_INET, socket.SOCK_STREAM)
        res = True
        try:
            # Connect to server and send data
            logger.debug("Connecting to "+self.host+":"+str(self.port))
            sock.connect((self.host, self.port))
            req = "GET /badcoin/getblocks"+nr+" HTTP/1.1\r\nHost: whatever\r\nConnection: close\r\n\r\n"
            logger.debug("Sending "+req)
            sock.sendall(req.encode())
            logger.debug("Sent")
            ok, lines = self.getResponse(sock)
            if not ok:
                logger.warn("Failed: "+str(lines))
            elif (len(lines)>0):
                rawblocks = "\n".join(lines)
                self.processBlocks(rawblocks)
                if not self.valid:
                    res = False
                    logger.debug("Got invalid blocks from server...")
        finally:
            sock.close()
        return self.valid
    
    def getTransactions(self):
        sock = socket.socket(socket.AF_INET, socket.SOCK_STREAM)
        res = []
        try:
            # Connect to server and send data
            sock.connect((self.host, self.port))
            sock.sendall(("GET /badcoin/gettransactions HTTP/1.1\r\nHost: whatever\r\nConnection: close\r\n\r\n").encode())
            logger.debug("Get transactions")
            ok, lines = self.getResponse(sock)
            if not ok:
                logger.warn("Failed: "+str(lines))
            elif len(lines)>0:
                res = map(lambda t: BadTransaction(t),lines)
        finally:
            sock.close()
        return res
        
    @classmethod
    def getResponse(cls, sock):
        response = sock.recv(4096).decode()
        lines = response.splitlines()
        logger.debug(lines)
        if (lines[0]!="HTTP/1.1 200 OK"):
                logger.warn(lines[0])
                return False, [lines[-1]]
        else:
            logger.debug("Got 200 OK")
            start = 0
            contentLength = 0
            while (lines[start]!=""):
                header = lines[start].split(":")
                if (header[0]=="Content-Length"):
                    contentLength = int(header[1])
                    logger.debug("ContentLength is "+str(contentLength))
                start+=1
            totalLength = contentLength+sum(map(lambda x:len(x)+2, lines[0:(start+1)]))
            logger.debug("Total length is "+str(totalLength)+", response is now "+str(len(response)))
            while len(response)<totalLength:
                response+=sock.recv(4096).decode()
                logger.debug("Total length is "+str(totalLength)+", response is now "+str(len(response)))
            lines = response.splitlines()
            return True, lines[(start+1):]
                
                
