# 
# To change this template, choose Tools | Templates
# and open the template in the editor.
 
require "feld"

module Spielbaum

  @@counter = 0

  def counter
    @@counter
  end

  def resetCounter
    @@counter=0
  end

  def to_pstricks(f, player=1,level=0)
    w = f.win?
    if w==0
      if f.blocked?(player)
        w=3-player
      end
    end
    if w>0 #or level>0
      return "\\TR{"+f.to_pstricks+"}\n" #" \\\\\nWin#{player}}\n"
    else
      res = "\\pstree{\\TR{"+f.to_pstricks+"}}{\n"
      f.each(player) {|ff|
        res += "  "*(level+1)+to_pstricks(ff,3-player,level+1)
      }
      res += "}\n"
      return res
    end
  end

  def to_svg(f, player=1, dx=50, dy=10, showSmile=true, cutoff=false)
    @@counter+=1
    kids = []
    y = 0
    res = ""
    smiley = -1
    if f.win? == 0
      f.each(player) {|ff|
        smiley = 2 if (smiley==-1)
        svg,bb,sm = to_svg(ff,3-player,dx,dy,showSmile, cutoff)
        if (sm==2)
          smiley = 1
        end
        #p bb,y
        svg = "<g transform='translate(0,#{y})'>\n"+svg+"</g>\n"
        res += svg
        kids.push(bb)
        y += bb[1]+dy;
        break if cutoff and smiley==1
      }
    end
    smiley = 2 if (smiley == -1)
    y-=dy if (y>0)
    maxy = y
    useSmiley = smiley
    useSmiley=0 unless showSmile
    svg,bbox = f.to_svg("", player, useSmiley)
    if (res!="")
      svg,bbox = f.to_svg("transform='translate(0,#{y/2-bbox[1]/2})'", player, useSmiley)
    end
    
    if (res!="")
      res = "<g transform='translate(#{bbox[0]+dx},0)'>\n"+res+"</g>\n"
    end
    res+=svg
    y = 0
    maxx = 0
    kids.each{|bb|
      style = ['stroke:#444;stroke-width:2;stroke-dasharray:5,5;','stroke:#000;stroke-width:2'][player-1]
      res += "<line x1='#{bbox[0]}' y1='#{maxy/2}' x2='#{bbox[0]+dx}' y2='#{y+bb[1]/2}' style='#{style}'/>\n"
      y+=bb[1]+dy
      maxx=bb[0] if bb[0]>maxx
    }
    y-=dy if (y>0)
    y = bbox[1] if (y<bbox[1])
    res = "<g>\n"+res+"</g>\n"

 
    return res, [bbox[0]+dx+maxx,y], smiley
  end
  
  def simple_tree_walk
    f = Feld.new(3,3)
    f.start_pos

    player = 1
    todo = [[f,player]]
    while todo.size>0
      ff,player = *(todo.shift)
      w = ff.win?
      if w==0 and ff.blocked?(player)
        w = 3-player
      end
      if w>0
        puts "Winner #{w}"
      end
      puts ff
      if w==0
        ff.each(player) {|o|
          todo.push([o,3-player])
        }
      end 
    end
  end
  
  def best_move(f,player)
    best = -1
    randf = nil
    n = 0
    f.each(player) {|ff|
      if ff.win?>0 or ff.blocked?(3-player)
        return 1,ff
      end
      win,feld = best_move(ff,3-player)
      if win==-1
        return 1,ff
      end
      if win==0
        best = 0
        bestf = ff
      end
      n+=1
      if (rand(n)==0)
        randf = ff
      end
    }
    if best==0
      return 0,ff
    else
      return -1,randf
    end
  end
end
