# 
# To change this template, choose Tools | Templates
# and open the template in the editor.
 

class Feld
  attr_reader :n, :m
  attr_accessor :feld
  
  def initialize(n,m)
    @n=n
    @m=m
    @feld = Array.new(n) { Array.new(m) { 0 }}    
  end
  
  def start_pos
    @m.times {|m|
      @feld[0][m] = 1
      @feld[@n-1][m] = 2
     }
  end
  
  def clone
    ret = Feld.new(@n,@m)
    @n.times {|n|
      @m.times {|m|
        ret.feld[n][m] = @feld[n][m]
      }
    }
    return ret
  end
  def win?
     @m.times {|m|
        if @feld[0][m] == 2
          return 2
        end
     }
     @m.times {|m|
        if @feld[@n-1][m] == 1
          return 1
        end
     }
     return 0
  end
  def blocked?(player)
    n=0
    each(player) {n+=1}
    return n==0
  end
  def legal?(n,m)
    return (n>=0 and m>=0 and n<@n and m<@m)
  end
  def each(player)
    if player == 1
      dir = 1
    else
      dir = -1
    end
    @n.times {|n|
      @m.times {|m|
        if @feld[n][m] == player
          # Gerade aus
          a,b = n+dir,m
          if legal?(a,b) and @feld[a][b] == 0
            zug = clone
            zug.feld[n][m] = 0
            zug.feld[a][b] = player
            yield(zug)
          end
          [-1,1].each {|d|
            a,b = n+dir,m+d
            if legal?(a,b) and @feld[a][b] == 3-player
              zug = clone
              zug.feld[n][m] = 0
              zug.feld[a][b] = player
              yield(zug)
            end
          }
        end
      }
    }
    
  end
  
  def to_s
    f = ["|   ", "| O ","| X "]
    l = "+---"*@m+"+\n"
    res = l
    @n.times {|n|
      @m.times {|m|
        res += f[@feld[n][m]]        
      }
      res += "|\n"+l
    }
    return res
  end
  
  def to_pstricks
    res = "\\begin{pspicture}(0,0)(#{@m},#{@n})\n"
    res += "\\psgrid[subgriddiv=0, gridcolor=black,labels=none]\n"
    @n.times {|n|
      @m.times {|m|
        if @feld[n][m] == 1
          res += "\\pscircle(#{m+0.5},#{n+0.5}){0.4}\n"
        elsif @feld[n][m] == 2
          res += "\\pscircle*(#{m+0.5},#{n+0.5}){0.4}\n"          
        end
      }
    }
    res += "\\end{pspicture}\n"
  end
  
  def to_svg(trans="", player=1, smiley=0)
    r = 10
    res = "<g #{trans}>"
    (@n+1).times{|y|
      res += "<line x1='0' y1='#{y*r}' x2='#{@m*r}' y2='#{y*r}' style='stroke:#000;stroke-width:1;stroke-linecap:square'/>\n"
    }
    (@m+1).times{|x|
      res += "<line x1='#{x*r}' y1='0' x2='#{x*r}' y2='#{@n*r}' style='stroke:#000;stroke-width:1;stroke-linecap:square'/>\n"
    }
    @n.times {|n|
      @m.times {|m|
        if @feld[n][m] >= 1
          res += "<circle cx='#{m*r+r/2}' cy='#{n*r+r/2}' r='#{r*10/25}' style='stroke:#000;fill:#{['#fff','#000'][@feld[n][m]-1]}'/>\n"        
        end
      }
    }
    winner = win?
    if winner==0 and blocked?(player)
      winner = 3-player;
    end
    if winner>0
      res += '<path fill="'+['#fff','#000'][winner-1]+'" stroke="#000" stroke-width="5" d="m25,1 6,17h18l-14,11 5,17-15-10-15,10 5-17-14-11h18z" transform="translate('+"#{@m*r+r/2},0"+') scale(0.2)"/>'
    end
    if (smiley>0)
      fill = (smiley==1) ? "#ff0" : "#f84"
      trans = (smiley==1) ? "" : " transform='translate(0,15) scale(1,-1)'"
      res += '<g transform="translate('+"#{(@m)*r/2},#{-r/2.5}"+') scale(0.15)">
  <circle r="20" stroke="black" stroke-width=".15" fill="'+fill+'"/>
  <ellipse rx="2.5" ry="4" cx="-6" cy="-7" fill="black"/>
  <ellipse rx="2.5" ry="4" cx="6" cy="-7" fill="black"/>
  <g'+trans+'>
  <path fill="none" stroke="black" stroke-width="1" stroke-linecap="round" d="M 10.6,2.7 a 4,4,0 0,0 4,3"/>
  <path transform="scale(-1,1)" fill="none" stroke="black" stroke-width="1" stroke-linecap="round" d="M 10.6,2.7 a 4,4,0 0,0 4,3"/>
  <path fill="none" stroke="black" stroke-width="1.5" d="M -10,8 A 13.5,13.5,0 0,0 10,8 A 11,11,0 0,1 -10,8"/></g></g>
'
    end
    return res+"</g>", [@m*r, @n*r]
  end

  def saveSVG(svg, filename="out.svg", bb=nil)
    wh = ""
    wh = " width='#{bb[0]}' height='#{bb[1]+20}'" if bb
    svg = '<svg xmlns="http://www.w3.org/2000/svg" version="1.1" '+wh+'>'+"\n<g transform='translate(0,10)'>"+svg+'</g></svg>'+"\n"
    File.open(filename,"w"){|f| f.puts svg }
  end
  
end
