class NimConfig

  def initialize(iniconfig)
    @iniConfig = Array.new(iniconfig)
    @rows = iniconfig.size
    # mixed bases for index
    @bases = iniconfig.map{|i| i+1}
    # value of each position (product of bases)
    @values = [1]
    (@rows-1).times{|i|
      @values[i+1] = @values[i]*@bases[i]
    }
    # Array with win(1)/loose(-1) information for each situation
    @situations = Array.new(@bases.inject(1){|i,m| m*i},0)
    # No matches means loss
    @situations[0] = -1
    # Counting the nodes in the subtree
    @kids = Array.new(@bases.inject(1){|i,m| m*i},0)
    # 1 node (no descendents)
    @kids[0] = 1
  end

  # Compute the index of this configuration
  def index(config)
    i = 0
    @rows.times{|r|
      i += @values[r]*config[r]
    }
    return i
  end

  # Compute the configuration from the index
  def getConfig(index)
    c = []
    @rows.times{|r|
      c.push(index % @bases[r])
      index /= @bases[r]
    }
    return c
  end
  
  # Get the situation evaluation from the configuration
  def get(config)
    return @situations[index(config)]
  end

  # Set the situation evaluation from the config
  def set(config, v)
    #puts "Config #{config.inspect} gets value #{v}"
    @situations[index(config)] = v
  end

  # Recursively compute the evaluation (and storing intermediate results)
  def compute(config)
    s = get(config)
    return s unless s==0
    # Go through all rows
    @rows.times{|r|
      # New array for new situation
      c = Array.new(config)
      # Make all possible moves in this row
      for i in 1..config[r]
        c[r] = config[r]-i
        s1 = compute(c)
        @kids[index(config)] += @kids[index(c)]
        # loss-sitution can be reached? So it's a win and we're done
        if (s1 == -1)
          set(config,1)
          return 1
        end
      end
    }
    # no loss-situation can be attained, so this is a loss situation
    set(config,-1)
    return -1
  end
  
  # Display all loosing situations, ordered with duplicates removed
  def putsLoosing()
    loosing = Hash.new
    @situations.size.times{|s|
      if @situations[s]==-1
        loosing[getConfig(s).sort.inspect] = 1
      end
    }
    puts loosing.keys.sort
  end

  # Compute all situations
  def computeAll()
    compute(@iniConfig)
    puts "Number of nodes: #{@kids[index(@iniConfig)]}"
    puts "Number of configs: #{@situations.size}"
  end
end


# Let's fetz!

nc = NimConfig.new([1,3,4,6]);
nc.computeAll()
puts "Loosing positions:"
nc.putsLoosing()
