nim =  {
    iniConfig: [1,3,5,7],
    
    init: function(config) {
        if (config) {
            this.iniConfig = config;
        }
        this.rows = this.iniConfig.length
        this.columns = Math.max.apply(Math, this.iniConfig);

        var table = $('<table/>');
        
        this.xorsum = 0;

        for (var i=0; i<this.rows; i++) {
            this.xorsum ^= this.iniConfig[i];
            var tr = $('<tr/>');
            table.append(tr);
            
            // closure, function returns a function with frozen local variables
            tr.click(function(num, that) {
                return function() {
                    that.remove(num);
                }
            }(i,this));

            tr.append("<td><span class='num' id='num"+i+"'></span></td>");

            var used = 0;
            for (var j=0; j<(this.columns-this.iniConfig[i])/2; j++) {
                tr.append("<td/>");
                used++;
            }
            for (var j=0; j<this.iniConfig[i]; j++) {
                tr.append("<td><img src='match.svg' id='img"+i+"_"+j+"'></td>")
                used++;
            }
            for (var j=used; j<this.columns; j++) {
                tr.append("<td/>");
            }
            tr.append("<td><span class='cheat' id='cheat"+i+"'></span></td>");
            tr.append("<td></td>");
            tr.append("<td><span class='cheat gr' id='gr"+i+"'></span></td>");
        }
        $('#nim').append(table);
        $('#nim').append("<span id='cheat'></span>");
        $('#nim').append("<input type='button' value='Reset' onclick='nim.reset()'/></td>");
        $("td").css({width:"50px", height:"207px", padding:"0px"});
        var style = { color:"white",'font-size':"40px", 'font-family':'sans'};
        $(".cheat").css(style);
        $(".num").css(style);
        $(".gr").css({color:'red'});
        this.reset();
    },
    
    setText: function() {
        for (var i=0; i<this.rows; i++) {
            $("#num"+i).html(""+this.state[i]);
            if (this.cheat) {
                $("#cheat"+i).html(""+this.state[i].toString(2));
                $("#gr"+i).html(""+(this.xorsum^this.state[i]));
            }
        }
    },

    remove: function(i) {
        if (this.state[i]>0) {
            this.xorsum ^= this.state[i];
            this.state[i]--;
            this.xorsum ^= this.state[i];
            $("#img"+i+"_"+this.state[i]).hide(400);
            this.setText();
        }
    },

    reset: function() {
        this.state = this.iniConfig.slice();
        this.xorsum = 0;
        for (var i=0; i<this.rows; i++) {
            this.xorsum ^= this.state[i];
            for (var j=0; j<this.state[i]; j++) {
                $("#img"+i+"_"+j).show(400);
            }
        }
        this.setText(i);
    },

}

$(document).ready(function() {
    var config = $.url().param('config');
    // Do not use this online, this is an XSS-security-hole!
    // Sanitize config first!
    if (config) {
        config = eval("["+config+"]");
    }
    var cheat = $.url().param('cheat');
    if (cheat) {
        nim.cheat = true;
    } else {
        nim.cheat = false;
    }
    nim.init(config);
});


