package nim;

import java.io.PrintStream;
import java.util.Iterator;
import java.util.Scanner;

/**
 * Example how to use the Situation class for the Nim Game
 */
public class Nim {

    /**
     * @param args the command line arguments
     */
    public static void main(String[] args) {
        Situation s = new Situation(4);
        int player = 0;
        Scanner scanner = new Scanner(System.in);
        while (!s.gameOver()) {
            System.out.format("Player %d%n%s%n",player+1,s);
            int r, n;
            while (true) {
                System.out.format("Which row? r=");
                r = scanner.nextInt();
                if (r>=0 && r<s.getSize() && s.getRow(r)>0) {
                    break;
                }
                System.out.format("  Invalid row, try again%n");
            }
            while (true) {
                System.out.format("How many? n=");
                n = scanner.nextInt();
                if (n>=1 && n<=s.getRow(r)) {
                    break;
                }
                System.out.format("  Enter a number between 1 and %d%n",s.getRow(r));
            }
            s.remove(r, n);
            System.out.format("%spossible successors (just to show off) %n",s);
            
            Situation ss = null;
            for (Iterator<Situation> i = s.iterator(); i.hasNext(); ss=i.next()) {
                System.out.format("Situation %d:%n",ss.getConfigNumber());
                System.out.print(ss);
            }
            System.out.format("Now continue playing ;-)%n%n");
            
            player ^=1;
        }
    }
}
