/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package needhamschroedergame;

import java.util.*;

/**
 *
 * @author ultesnit
 */
public class NeedhamSchroederGame {

    enum Destinations {

        ALICE, BOB, VERIFIER, NONE
    }

//    enum Keys {
//
//        ALICE_PUBLIC, ALICE_PRIVATE, BOB_PUBLIC, BOB_PRIVATE, VERIFIER_PUBLIC, VERIFIER_PRIVATE, NONE
//    }
    enum Signatures {

        SIGNATURE_A, SIGNATURE_B, SIGNATURE_V, NONE
    }

    enum RandomNumbers {

        NONCE_A, KEY_A, NONCE_B, KEY_B, NONCE_V, KEY_V, NONE
    }

    static class Message implements Cloneable {

        private Destinations destination;
//        private Keys key;
        private Signatures signature;
        private RandomNumbers nonce;
        private RandomNumbers newKey;

        public Message() {
            destination = Destinations.NONE;
            //          key = Keys.NONE;
            signature = Signatures.NONE;
            nonce = RandomNumbers.NONE;
            newKey = RandomNumbers.NONE;
        }

        private boolean isEmpty() {
            return (destination == Destinations.NONE && signature == Signatures.NONE && nonce == RandomNumbers.NONE && newKey == RandomNumbers.NONE);
        }

        public void set(Destinations d, Signatures s, RandomNumbers n, RandomNumbers c) {
            destination = d;
//            key = k;
            signature = s;
            nonce = n;
            newKey = c;
        }

        @Override
        protected Object clone() throws CloneNotSupportedException {
            return super.clone();
        }
    }
    static Message Internet = new Message();

    static class Alice implements Cloneable {

        int state = 0;
        Destinations me = Destinations.ALICE;
        Destinations other = Destinations.BOB;
        Signatures mySignature = Signatures.SIGNATURE_A;
        RandomNumbers knowsKey = RandomNumbers.KEY_A;
        RandomNumbers knowsNonce = RandomNumbers.NONCE_A;
        RandomNumbers storedKey = RandomNumbers.NONE;
        Destinations believedDestination = Destinations.NONE;

        public boolean canSend() {
            return ((Internet.isEmpty() && state == 0));
        }

        public void send(Destinations d) {
            state = 1;
            Internet.set(d, mySignature, knowsNonce, RandomNumbers.NONE);
            believedDestination = d;
        }

        public boolean canRead() {
            return (Internet.destination == me && ((state == 0 && Internet.signature != mySignature && Internet.signature != Signatures.NONE && (Internet.nonce == RandomNumbers.NONCE_B || Internet.nonce == RandomNumbers.NONCE_V)) || (state == 1 && knowsNonce == Internet.nonce) || (state == 2 && storedKey == Internet.newKey)));
        }

        public void read() {
            if (state == 0) {
                if (Internet.signature == Signatures.SIGNATURE_V) {
                    believedDestination = Destinations.VERIFIER;
                } else {
                    believedDestination = other;
                }
                Internet.destination = believedDestination;
                Internet.signature = Signatures.NONE;
                storedKey = knowsKey;
                Internet.newKey = storedKey;
                state = 2;
            } else if (state == 1) {
                state = 3;
                storedKey = Internet.newKey;
                Internet.set(believedDestination, Signatures.NONE, RandomNumbers.NONE, storedKey);
            } else {
                state = 3;
            }
        }

        @Override
        protected Object clone() throws CloneNotSupportedException {
            return super.clone();
        }
    }

    static class Bob implements Cloneable {

        int state = 0;
        Destinations me = Destinations.BOB;
        Destinations other = Destinations.ALICE;
        Signatures mySignature = Signatures.SIGNATURE_B;
        RandomNumbers knowsKey = RandomNumbers.KEY_B;
        RandomNumbers knowsNonce = RandomNumbers.NONCE_B;
        RandomNumbers storedKey = RandomNumbers.NONE;
        Destinations believedDestination = Destinations.NONE;

        public boolean canSend() {
            return ((Internet.isEmpty() && state == 0));
        }

        public void send(Destinations d) {
            state = 1;
            Internet.set(d, mySignature, knowsNonce, RandomNumbers.NONE);
            believedDestination = d;
        }

        public boolean canRead() {
            return (Internet.destination == me && ((state == 0 && Internet.signature != mySignature && Internet.signature != Signatures.NONE && (Internet.nonce == RandomNumbers.NONCE_A || Internet.nonce == RandomNumbers.NONCE_V)) || (state == 1 && knowsNonce == Internet.nonce) || (state == 2 && storedKey == Internet.newKey)));
        }

        public void read() {
            if (state == 0) {
                if (Internet.signature == Signatures.SIGNATURE_V) {
                    believedDestination = Destinations.VERIFIER;
                } else {
                    believedDestination = other;
                }
                Internet.destination = believedDestination;
                Internet.signature = Signatures.NONE;
                storedKey = knowsKey;
                Internet.newKey = storedKey;
                state = 2;
            } else if (state == 1) {
                state = 3;
                storedKey = Internet.newKey;
                Internet.set(believedDestination, Signatures.NONE, RandomNumbers.NONE, storedKey);
            } else {
                state = 3;
            }
        }

        @Override
        protected Object clone() throws CloneNotSupportedException {
            return super.clone();
        }
    }

    static class Verifier implements Cloneable {

        int state = 0;
        boolean knowsKeyA = false;
        boolean knowsKeyB = false;
        boolean knowsKeyV = true;

        public void sniffs() {
            if (Internet.destination == Destinations.VERIFIER && Internet.newKey == RandomNumbers.KEY_A) {
                knowsKeyA = true;
            }
            if (Internet.destination == Destinations.VERIFIER && Internet.newKey == RandomNumbers.KEY_B) {
                knowsKeyB = true;
            }
        }

        public void deviatesToA() {
            if (Internet.destination == Destinations.VERIFIER) {
                Internet.destination = Destinations.ALICE;
            }
        }

        public void deviatesToB() {
            if (Internet.destination == Destinations.VERIFIER) {
                Internet.destination = Destinations.BOB;
            }
        }

        @Override
        protected Object clone() throws CloneNotSupportedException {
            return super.clone();
        }
    }

    public static void main(String[] args) throws CloneNotSupportedException {
        Alice alice = new Alice();
        Bob bob = new Bob();
        Verifier verif = new Verifier();

        simulate(alice, bob, verif, false, Internet, 1);
    }

    public static boolean simulate(Alice alice, Bob bob, Verifier verif, boolean active, Message net, int i) throws CloneNotSupportedException {
        boolean result = true;
        Alice a;
        Bob b;
        String communication = "";

//        System.out.println(Internet.destination.toString() + ", " + Internet.signature.toString() + ", " + Internet.nonce.toString() + ", " + Internet.newKey.toString());


        if (!(alice.canRead() || alice.canSend() || bob.canRead() || bob.canSend()) && !active) {
            if (alice.believedDestination == Destinations.BOB) {
                if (alice.storedKey == RandomNumbers.KEY_A && verif.knowsKeyA) {
                    System.out.println("Alice was fooled ...");
                    result = false;
                } else if (alice.storedKey == RandomNumbers.KEY_B && verif.knowsKeyB) {
                    System.out.println("Alice was fooled ...");
                    result = false;
                }
            }
            if (bob.believedDestination == Destinations.ALICE) {
                if (bob.storedKey == RandomNumbers.KEY_A && verif.knowsKeyA) {
                    System.out.println("Bob was fooled ...");
                    result = false;
                } else if (bob.storedKey == RandomNumbers.KEY_B && verif.knowsKeyB) {
                    System.out.println("Bob was fooled ...");
                    result = false;
                }
            }
            if (result) {
                System.out.println("Nobody was fooled ...");
            }
        } else {

            if (active) {
                verif.sniffs();
                Internet = (Message) net.clone();
                communication = "Verifier does nothing (except sniffing) ...";
                result = simulate(alice, bob, verif, !active, Internet, i);
                if (result) {
                    Internet = (Message) net.clone();
                    verif.deviatesToA();
                    communication = "Verifier deviates to Alice ...";
                    result = simulate(alice, bob, verif, !active, Internet, i);
                    if (result) {
                        Internet = (Message) net.clone();
                        verif.deviatesToB();
                        communication = "Verifier deviates to Bob ...";
                        result = simulate(alice, bob, verif, !active, Internet, i);
                        Internet = (Message) net.clone();
                    }
                }
            } else {
                if (alice.canRead()) {
                    Internet = (Message) net.clone();
                    a = (Alice) alice.clone();
                    a.read();
                    communication = "Alice reads ...";
                    result = simulate(a, bob, verif, !active, Internet, i + 1);
                }
                if (result && alice.canSend()) {
                    Internet = (Message) net.clone();
                    a = (Alice) alice.clone();
                    a.send(Destinations.BOB);
                    communication = "Alice sends to Bob ...";
                    result = simulate(a, bob, verif, !active, Internet, i + 1);
                    if (result) {
                        Internet = (Message) net.clone();
                        a = (Alice) alice.clone();
                        a.send(Destinations.VERIFIER);
                        communication = "Alice sends to Verifier ...";
                        result = simulate(a, bob, verif, !active, Internet, i + 1);
                    }
                }
                if (result && bob.canRead()) {
                    Internet = (Message) net.clone();
                    b = (Bob) bob.clone();
                    b.read();
                    communication = "Bob reads ...";
                    result = simulate(alice, b, verif, !active, Internet, i + 1);
                }
                if (result && bob.canSend()) {
                    Internet = (Message) net.clone();
                    b = (Bob) bob.clone();
                    b.send(Destinations.ALICE);
                    communication = "Bob sends to Alice ...";
                    result = simulate(alice, b, verif, !active, Internet, i + 1);
                    if (result) {
                        Internet = (Message) net.clone();
                        b = (Bob) bob.clone();
                        b.send(Destinations.VERIFIER);
                        communication = "Bob sends to Verifier ...";
                        result = simulate(alice, b, verif, !active, Internet, i + 1);
                    }
                }
            }
        }

        if (!result) {
            System.out.println(communication);
        }
        return result;
    }
}
