def makePsTree(level, min, max, alpha, beta, solution=false)
  origalpha = alpha
  ev = (rand(19)-9)
  rad = "5mm"
  contents = ""
  if (level == min.size) 
    rad = "3mm"
    contents = ev.to_s
  else
    ev = -10 
  end
  subtree = ""
  if (level<min.size) 
    (rand(max[level]-min[level]+1)+min[level]).times {
      r,evc = makePsTree(level+1, min, max, -beta, -alpha, solution)
      subtree += r
      if (-evc > ev)
        ev = -evc
        if (-evc > alpha)
          alpha = -evc
        end
      end
    }
  end
  pruning = ""
  color = ""
  if solution
    contents = ev.to_s
    pruning = "\\naput{#{origalpha},#{beta}}"
    if (origalpha>=beta) 
      color = "\\psset{linecolor=red} "
    end
  end
  res = "  "*level + "\\pstree{#{color}\\TCircle[radius=#{rad}]{\\small #{contents}}#{pruning}}{\n"
  res += subtree
  res += "  "*level + "}\n";
  return res, ev
  
end

first = true
while seed = ARGV.shift
  seed = seed.to_i
  srand(seed)

  puts '\newpage' unless first
  first = false
  puts '{\bf \Huge \sf Tree '+seed.to_s+'}\\\\[5mm]'
  
  tree,ev = makePsTree(0,[2,2,1,1],[2,2,4,4], -10, 10, false)
  puts tree
  
  srand(seed)
  tree,ev = makePsTree(0,[2,2,1,1],[2,2,4,4], -10, 10, true)
  
  puts '\newpage{\bf \Huge \sf Solution '+seed.to_s+'}\\\\[5mm]'
  puts tree
end

