package viergewinnt;

import java.util.Arrays;
import java.util.Locale;
import java.util.Random;
import java.util.Scanner;

/**
 * This class is not used anymore, but left here as a (bad) example.
 */
public class VierGewinnt {

    static BitFieldClumsy field = new BitFieldClumsy(7,6);
    static int bestPosition;
    static double[] values = new double[7];
    static int[] order = new int[] {0,1,2,3,4,5,6};
    
    /**
     * @param args the command line arguments
     */
    public static void main(String[] args) {
        Scanner s = new Scanner(System.in);
        while (!field.checkWin(1-field.getPlayer())) {
            System.out.format("%s%n", field);
            field.evaluatePlayerZero();
            if (field.getPlayer()==2) {
                System.out.format("Input row number >");
                field.makeMove(s.nextInt());
                System.out.format("EvaluationZero : %f%n",field.evaluatePlayerZero());
                System.out.format("Evaluation 0 : %f%n",field.evaluate(0));
                System.out.format("Evaluation 1 : %f%n",field.evaluate(1));
            } else {
                long startTime = System.nanoTime();
                double v;
//                v=evaluateSituation(8,true);
//                startTime = System.nanoTime() - startTime;
//                System.out.format("Complete tree : %fms, value %f, decision %d%n", startTime/1.0e6, v,  bestPosition);
                startTime = System.nanoTime();
                if (field.getPlayer()==10) {
                    v=iterativeDeepening(1000);
                } else {
                    v=orderedIterativeDeepening(1000);
                }
//                v=alphaBetaPruning(12,true,-1.0, 1.0);
                startTime = System.nanoTime() - startTime;
                System.out.format("Alpha-Beta-Pruning : %fms, value %f, decision %d%n", startTime/1.0e6, v,  bestPosition);
                field.makeMove(bestPosition);
            }
        }
        System.out.format("%s%n", field);
    }
    
    public static double evaluateSituation(int maxDepth, boolean first) {
        double mul = (field.getPlayer()==0) ? 1.0 : -1.0;
        double bestv=-1.0;
        boolean found = false;
        for (int w=0; w<field.width; w++) {
            if (field.isOpen(w)) {
                if (first && !found) {
                    bestPosition = w;
                    found = true;
                }
                field.makeMove(w);
                double v;
                if (field.checkWin(1-field.getPlayer())) {
                    v = 1.0;
                } else if (field.checkDraw()) {
                    v = 0.0;
                } else {
                    if (maxDepth==0) {
                        v = mul*field.evaluatePlayerZero();
                    } else {
                        v = -evaluateSituation(maxDepth-1, false);
                    }
                }
                field.undoMove();
                //System.out.format("Trying position [[UNDONE]]%n%s",field);
//                if (first) {
//                    System.out.format("Configuration at pos %d at value %f:%n%s",w,v,field);
//                }
                // winning move
                if (v==1.0) {
                    if (first) {
                        bestPosition = w;
                    } 
                    return 1.0;
                }
                if (v>bestv) {
                    if (first) {
                        bestPosition = w;
                    } 
                    bestv = v;
                }
            }
        }
        return bestv;
    }
    
    // alpha: how well the current player can do
    // beta: how well the opponent can possibly do
    public static double alphaBetaPruning(int maxDepth, boolean first, double alpha, double beta) {
        boolean found = false;
        double mul = (field.getPlayer()==0) ? 1.0 : -1.0;
        if (first) {
            Arrays.fill(values, -1.0);
        }
        for (int i=0; i<field.width; i++) {
            int w = order[i];
            if (field.isOpen(w)) {
                if (first && !found) {
                    bestPosition = w;
                    found = true;
                }
                field.makeMove(w);
                double v;
                if (field.checkWin(1-field.getPlayer())) {
                    //System.out.format("Winning position at %d%n%s",maxDepth,field);
                    v = 1.0;
                } else if (field.checkDraw()) {
                    v = 0.0;
                } else {
                    if (maxDepth==0) {
                        v = mul*field.evaluatePlayerZero();
                    } else {
                        v = -alphaBetaPruning(maxDepth-1, false, -beta, -alpha);
                    }
                }
                field.undoMove();
                if (first) {
                    values[w] = v;
//                    System.out.format("Configuration at pos %d at value %f:%n%s",w,v,field);
                }

                if (v>alpha) {
                    if (first) bestPosition = w;
                    alpha = v;
                }
                if (beta<=alpha) {                        
                    return alpha;
                }                
            }
        }
        return alpha;
    }
    

    
    public static double iterativeDeepening(int maxMilis) {
        double v=0.0;
        for (int d = 6; d<field.width*field.height; d+=2) {
            long startTime = System.nanoTime();
            v = alphaBetaPruning(d,true,-1.0, 1.0);
//            v = evaluateSituation(d,true);
            startTime = (System.nanoTime()-startTime)/1000000;
            System.out.format("Depth %d, value %f, decision %d, %dms%n",d,v,bestPosition, startTime);
            if (startTime > maxMilis || v==1.0 || v==-1.0) {
                return v;
            }
        }
        return v;
    }
    
    public static double orderedIterativeDeepening(int maxMilis) {
        double v=0.0;
        order = new int[] {3,4,2,5,1,6,0};
        Random r = new Random();
        if (r.nextBoolean()) {
            order[1]=2;
            order[2]=4;
        }
        if (r.nextBoolean()) {
            order[3]=1;
            order[4]=5;
        }
        if (r.nextBoolean()) {
            order[5]=0;
            order[6]=6;
        }
        for (int d = 6; d<field.width*field.height; d++) {
            System.out.format("Order is %s%n", Arrays.toString(order));
            long startTime = System.nanoTime();
            v = alphaBetaPruning(d,true,-1.0, 1.0);
            startTime = (System.nanoTime()-startTime)/1000000;
            System.out.format("Values are %s%n", Arrays.toString(values));
            System.out.format("Depth %d, value %f, decision %d, %dms%n",d,v,bestPosition, startTime);
            if (startTime > maxMilis || v==1.0 || v==-1.0) {
                return v;
            }

//            // Stupid sort
//            for (int i=0; i<7; i++) {
//                int p=0;
//                for (int j=1; j<7; j++) {
//                    if (values[p]<values[j]) {
//                        p = j;
//                    }
//                }
//                order[i] = p;
//                values[p] = -2.0;
//            }
            
        }
        return v;
    }

    
}
